/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.utils;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClusterInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestUtil {
    public static Map<String, String> toParameters(Service service) {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", service.getNamespaceId());
        params.put("groupName", service.getGroupName());
        params.put("serviceName", service.getName());
        params.put("metadata", JacksonUtils.toJson((Object)service.getMetadata()));
        params.put("ephemeral", String.valueOf(service.isEphemeral()));
        params.put("protectThreshold", String.valueOf(service.getProtectThreshold()));
        params.put("selector", JacksonUtils.toJson((Object)service.getSelector()));
        return params;
    }

    public static Map<String, String> toParameters(Service service, Instance instance) {
        HashMap<String, String> params = new HashMap<String, String>(11);
        params.put("namespaceId", service.getNamespaceId());
        params.put("groupName", service.getGroupName());
        params.put("serviceName", service.getName());
        params.put("clusterName", instance.getClusterName());
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("weight", String.valueOf(instance.getWeight()));
        params.put("healthy", String.valueOf(instance.isHealthy()));
        params.put("enabled", String.valueOf(instance.isEnabled()));
        params.put("metadata", JacksonUtils.toJson((Object)instance.getMetadata()));
        params.put("ephemeral", String.valueOf(instance.isEphemeral()));
        return params;
    }

    public static Map<String, String> toParameters(Service service, List<Instance> instances, Map<String, String> newMetadata) {
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("namespaceId", service.getNamespaceId());
        params.put("groupName", service.getGroupName());
        params.put("serviceName", service.getName());
        params.put("instances", JacksonUtils.toJson(instances));
        params.put("consistencyType", instances.get(0).isEphemeral() ? "ephemeral" : "persist");
        params.put("metadata", JacksonUtils.toJson(newMetadata));
        return params;
    }

    public static Map<String, String> toParameters(Service service, ClusterInfo cluster) {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", service.getNamespaceId());
        params.put("groupName", service.getGroupName());
        params.put("serviceName", service.getName());
        params.put("clusterName", cluster.getClusterName());
        params.put("checkPort", String.valueOf(cluster.getHealthyCheckPort()));
        params.put("useInstancePort4Check", String.valueOf(cluster.isUseInstancePortForCheck()));
        params.put("healthChecker", JacksonUtils.toJson((Object)cluster.getHealthChecker()));
        params.put("metadata", JacksonUtils.toJson((Object)cluster.getMetadata()));
        return params;
    }
}

