/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.datasource.processor;

import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.datasource.SmartDataSource;
import com.alipay.sofa.tracer.plugins.datasource.utils.DataSourceUtils;
import java.util.Arrays;
import java.util.HashSet;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class DataSourceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
PriorityOrdered,
EnvironmentAware {
    public static final String SOFA_TRACER_DATASOURCE = "s_t_d_s_";
    private Environment environment;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : this.getBeanNames((ListableBeanFactory)beanFactory, DataSource.class)) {
            if (beanName.startsWith(SOFA_TRACER_DATASOURCE)) continue;
            BeanDefinition dataSource = this.getBeanDefinition(beanName, beanFactory);
            if (DataSourceUtils.isDruidDataSource((String)dataSource.getBeanClassName())) {
                this.createDataSourceProxy(beanFactory, beanName, dataSource, DataSourceUtils.getDruidJdbcUrlKey());
                continue;
            }
            if (DataSourceUtils.isC3p0DataSource((String)dataSource.getBeanClassName())) {
                this.createDataSourceProxy(beanFactory, beanName, dataSource, DataSourceUtils.getC3p0JdbcUrlKey());
                continue;
            }
            if (DataSourceUtils.isDbcpDataSource((String)dataSource.getBeanClassName())) {
                this.createDataSourceProxy(beanFactory, beanName, dataSource, DataSourceUtils.getDbcpJdbcUrlKey());
                continue;
            }
            if (DataSourceUtils.isTomcatDataSource((String)dataSource.getBeanClassName())) {
                this.createDataSourceProxy(beanFactory, beanName, dataSource, DataSourceUtils.getTomcatJdbcUrlKey());
                continue;
            }
            if (!DataSourceUtils.isHikariDataSource((String)dataSource.getBeanClassName())) continue;
            this.createDataSourceProxy(beanFactory, beanName, dataSource, DataSourceUtils.getHikariJdbcUrlKey());
        }
    }

    private Iterable<String> getBeanNames(ListableBeanFactory beanFactory, Class clazzType) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, (Class)clazzType, (boolean)true, (boolean)false)));
        return names;
    }

    private BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return this.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw ex;
        }
    }

    private void createDataSourceProxy(ConfigurableListableBeanFactory beanFactory, String beanName, BeanDefinition originDataSource, String jdbcUrl) {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        beanDefinitionRegistry.removeBeanDefinition(beanName);
        boolean isPrimary = originDataSource.isPrimary();
        originDataSource.setPrimary(false);
        beanDefinitionRegistry.registerBeanDefinition(DataSourceBeanFactoryPostProcessor.transformDatasourceBeanName(beanName), originDataSource);
        RootBeanDefinition proxiedBeanDefinition = new RootBeanDefinition(SmartDataSource.class);
        proxiedBeanDefinition.setRole(0);
        proxiedBeanDefinition.setPrimary(isPrimary);
        proxiedBeanDefinition.setInitMethodName("init");
        proxiedBeanDefinition.setDependsOn(new String[]{DataSourceBeanFactoryPostProcessor.transformDatasourceBeanName(beanName)});
        MutablePropertyValues originValues = originDataSource.getPropertyValues();
        MutablePropertyValues values = new MutablePropertyValues();
        String appName = this.environment.getProperty("spring.application.name");
        Assert.isTrue((!StringUtils.isBlank((String)appName) ? 1 : 0) != 0, (String)"spring.application.name must be configured!");
        values.add("appName", (Object)appName);
        values.add("delegate", (Object)new RuntimeBeanReference(DataSourceBeanFactoryPostProcessor.transformDatasourceBeanName(beanName)));
        values.add("dbType", (Object)DataSourceUtils.resolveDbTypeFromUrl((String)this.unwrapPropertyValue(originValues.get(jdbcUrl))));
        values.add("database", (Object)DataSourceUtils.resolveDatabaseFromUrl((String)this.unwrapPropertyValue(originValues.get(jdbcUrl))));
        proxiedBeanDefinition.setPropertyValues(values);
        beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)proxiedBeanDefinition);
    }

    protected String unwrapPropertyValue(Object propertyValue) {
        if (propertyValue instanceof TypedStringValue) {
            return ((TypedStringValue)propertyValue).getValue();
        }
        if (propertyValue instanceof String) {
            return (String)propertyValue;
        }
        throw new IllegalArgumentException("The property value of jdbcUrl must be the type of String or TypedStringValue");
    }

    public static String transformDatasourceBeanName(String originName) {
        return SOFA_TRACER_DATASOURCE + originName;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

