/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.flexible.processor;

import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.boot.flexible.processor.MethodInvocationProcessor;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleTracer;
import io.opentracing.Tracer;
import org.aopalliance.intercept.MethodInvocation;

public class SofaTracerMethodInvocationProcessor
implements MethodInvocationProcessor {
    private Tracer tracer;

    public SofaTracerMethodInvocationProcessor(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Object process(MethodInvocation invocation, com.alipay.sofa.tracer.plugin.flexible.annotations.Tracer tracerSpan) throws Throwable {
        return this.proceedProxyMethodWithTracerAnnotation(invocation, tracerSpan);
    }

    private Object proceedProxyMethodWithTracerAnnotation(MethodInvocation invocation, com.alipay.sofa.tracer.plugin.flexible.annotations.Tracer tracerSpan) throws Throwable {
        if (this.tracer instanceof FlexibleTracer) {
            try {
                String operationName = tracerSpan.operateName();
                if (StringUtils.isBlank((String)operationName)) {
                    operationName = invocation.getMethod().getName();
                }
                SofaTracerSpan sofaTracerSpan = ((FlexibleTracer)this.tracer).beforeInvoke(operationName);
                sofaTracerSpan.setTag("method", invocation.getMethod().getName());
                if (invocation.getArguments() != null && invocation.getArguments().length != 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object obj : invocation.getArguments()) {
                        stringBuilder.append(obj.getClass().getName()).append(";");
                    }
                    sofaTracerSpan.setTag("param.types", stringBuilder.toString().substring(0, stringBuilder.length() - 1));
                }
                Object result = invocation.proceed();
                ((FlexibleTracer)this.tracer).afterInvoke();
                return result;
            }
            catch (Throwable t) {
                ((FlexibleTracer)this.tracer).afterInvoke(t.getMessage());
                throw t;
            }
        }
        return invocation.proceed();
    }
}

