/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.resttemplate;

import com.alipay.common.tracer.core.tracer.AbstractTracer;
import com.sofa.alipay.tracer.plugins.rest.SofaTracerRestTemplateBuilder;
import com.sofa.alipay.tracer.plugins.rest.interceptor.RestTemplateInterceptor;
import java.util.ArrayList;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

public class SofaTracerRestTemplateEnhance {
    private final RestTemplateInterceptor restTemplateInterceptor;

    public SofaTracerRestTemplateEnhance() {
        AbstractTracer restTemplateTracer = SofaTracerRestTemplateBuilder.getRestTemplateTracer();
        this.restTemplateInterceptor = new RestTemplateInterceptor(restTemplateTracer);
    }

    public void enhanceRestTemplateWithSofaTracer(RestTemplate restTemplate) {
        if (this.checkRestTemplateInterceptor(restTemplate)) {
            return;
        }
        ArrayList<RestTemplateInterceptor> interceptors = new ArrayList<RestTemplateInterceptor>(restTemplate.getInterceptors());
        interceptors.add(0, this.restTemplateInterceptor);
        restTemplate.setInterceptors(interceptors);
    }

    private boolean checkRestTemplateInterceptor(RestTemplate restTemplate) {
        for (ClientHttpRequestInterceptor interceptor : restTemplate.getInterceptors()) {
            if (!(interceptor instanceof RestTemplateInterceptor)) continue;
            return true;
        }
        return false;
    }
}

