/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateEditingProjectRequest
extends Request {
    @Query
    @NameInMap(value="BusinessConfig")
    private String businessConfig;
    @Query
    @NameInMap(value="ClipsParam")
    private String clipsParam;
    @Query
    @NameInMap(value="CoverURL")
    private String coverURL;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="MaterialMaps")
    private String materialMaps;
    @Query
    @NameInMap(value="ProjectType")
    private String projectType;
    @Query
    @NameInMap(value="TemplateId")
    private String templateId;
    @Query
    @NameInMap(value="TemplateType")
    private String templateType;
    @Body
    @NameInMap(value="Timeline")
    private String timeline;
    @Query
    @NameInMap(value="Title")
    @Validation(required=true)
    private String title;

    private CreateEditingProjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.businessConfig = builder.businessConfig;
        this.clipsParam = builder.clipsParam;
        this.coverURL = builder.coverURL;
        this.description = builder.description;
        this.materialMaps = builder.materialMaps;
        this.projectType = builder.projectType;
        this.templateId = builder.templateId;
        this.templateType = builder.templateType;
        this.timeline = builder.timeline;
        this.title = builder.title;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateEditingProjectRequest create() {
        return CreateEditingProjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBusinessConfig() {
        return this.businessConfig;
    }

    public String getClipsParam() {
        return this.clipsParam;
    }

    public String getCoverURL() {
        return this.coverURL;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMaterialMaps() {
        return this.materialMaps;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public String getTimeline() {
        return this.timeline;
    }

    public String getTitle() {
        return this.title;
    }

    public static final class Builder
    extends Request.Builder<CreateEditingProjectRequest, Builder> {
        private String businessConfig;
        private String clipsParam;
        private String coverURL;
        private String description;
        private String materialMaps;
        private String projectType;
        private String templateId;
        private String templateType;
        private String timeline;
        private String title;

        private Builder() {
        }

        private Builder(CreateEditingProjectRequest request) {
            super((Request)request);
            this.businessConfig = request.businessConfig;
            this.clipsParam = request.clipsParam;
            this.coverURL = request.coverURL;
            this.description = request.description;
            this.materialMaps = request.materialMaps;
            this.projectType = request.projectType;
            this.templateId = request.templateId;
            this.templateType = request.templateType;
            this.timeline = request.timeline;
            this.title = request.title;
        }

        public Builder businessConfig(String businessConfig) {
            this.putQueryParameter("BusinessConfig", businessConfig);
            this.businessConfig = businessConfig;
            return this;
        }

        public Builder clipsParam(String clipsParam) {
            this.putQueryParameter("ClipsParam", clipsParam);
            this.clipsParam = clipsParam;
            return this;
        }

        public Builder coverURL(String coverURL) {
            this.putQueryParameter("CoverURL", coverURL);
            this.coverURL = coverURL;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder materialMaps(String materialMaps) {
            this.putQueryParameter("MaterialMaps", materialMaps);
            this.materialMaps = materialMaps;
            return this;
        }

        public Builder projectType(String projectType) {
            this.putQueryParameter("ProjectType", projectType);
            this.projectType = projectType;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putQueryParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public Builder templateType(String templateType) {
            this.putQueryParameter("TemplateType", templateType);
            this.templateType = templateType;
            return this;
        }

        public Builder timeline(String timeline) {
            this.putBodyParameter("Timeline", timeline);
            this.timeline = timeline;
            return this;
        }

        public Builder title(String title) {
            this.putQueryParameter("Title", title);
            this.title = title;
            return this;
        }

        public CreateEditingProjectRequest build() {
            return new CreateEditingProjectRequest(this);
        }
    }
}

