/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateRecognitionEntityRequest
extends Request {
    @Query
    @NameInMap(value="Algorithm")
    @Validation(required=true)
    private String algorithm;
    @Query
    @NameInMap(value="EntityInfo")
    private String entityInfo;
    @Query
    @NameInMap(value="EntityName")
    @Validation(required=true)
    private String entityName;
    @Query
    @NameInMap(value="LibId")
    @Validation(required=true)
    private String libId;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;

    private CreateRecognitionEntityRequest(Builder builder) {
        super((Request.Builder)builder);
        this.algorithm = builder.algorithm;
        this.entityInfo = builder.entityInfo;
        this.entityName = builder.entityName;
        this.libId = builder.libId;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateRecognitionEntityRequest create() {
        return CreateRecognitionEntityRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getEntityInfo() {
        return this.entityInfo;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getLibId() {
        return this.libId;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public static final class Builder
    extends Request.Builder<CreateRecognitionEntityRequest, Builder> {
        private String algorithm;
        private String entityInfo;
        private String entityName;
        private String libId;
        private String ownerAccount;
        private Long ownerId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;

        private Builder() {
        }

        private Builder(CreateRecognitionEntityRequest request) {
            super((Request)request);
            this.algorithm = request.algorithm;
            this.entityInfo = request.entityInfo;
            this.entityName = request.entityName;
            this.libId = request.libId;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
        }

        public Builder algorithm(String algorithm) {
            this.putQueryParameter("Algorithm", algorithm);
            this.algorithm = algorithm;
            return this;
        }

        public Builder entityInfo(String entityInfo) {
            this.putQueryParameter("EntityInfo", entityInfo);
            this.entityInfo = entityInfo;
            return this;
        }

        public Builder entityName(String entityName) {
            this.putQueryParameter("EntityName", entityName);
            this.entityName = entityName;
            return this;
        }

        public Builder libId(String libId) {
            this.putQueryParameter("LibId", libId);
            this.libId = libId;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public CreateRecognitionEntityRequest build() {
            return new CreateRecognitionEntityRequest(this);
        }
    }
}

