/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.ice20201109.models.AIAgentConfig;
import com.aliyun.sdk.service.ice20201109.models.AIAgentTemplateConfig;
import darabonba.core.TeaModel;

public class GenerateAIAgentCallRequest
extends Request {
    @Query
    @NameInMap(value="AIAgentId")
    @Validation(required=true)
    private String AIAgentId;
    @Query
    @NameInMap(value="AgentConfig")
    private AIAgentConfig agentConfig;
    @Query
    @NameInMap(value="ChatSyncConfig")
    private ChatSyncConfig chatSyncConfig;
    @Query
    @NameInMap(value="Expire")
    private Long expire;
    @Query
    @NameInMap(value="SessionId")
    private String sessionId;
    @Query
    @NameInMap(value="TemplateConfig")
    @Deprecated
    private AIAgentTemplateConfig templateConfig;
    @Query
    @NameInMap(value="UserData")
    private String userData;
    @Query
    @NameInMap(value="UserId")
    private String userId;

    private GenerateAIAgentCallRequest(Builder builder) {
        super((Request.Builder)builder);
        this.AIAgentId = builder.AIAgentId;
        this.agentConfig = builder.agentConfig;
        this.chatSyncConfig = builder.chatSyncConfig;
        this.expire = builder.expire;
        this.sessionId = builder.sessionId;
        this.templateConfig = builder.templateConfig;
        this.userData = builder.userData;
        this.userId = builder.userId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GenerateAIAgentCallRequest create() {
        return GenerateAIAgentCallRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAIAgentId() {
        return this.AIAgentId;
    }

    public AIAgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public ChatSyncConfig getChatSyncConfig() {
        return this.chatSyncConfig;
    }

    public Long getExpire() {
        return this.expire;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public AIAgentTemplateConfig getTemplateConfig() {
        return this.templateConfig;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getUserId() {
        return this.userId;
    }

    public static class ChatSyncConfig
    extends TeaModel {
        @NameInMap(value="IMAIAgentId")
        private String IMAIAgentId;
        @NameInMap(value="ReceiverId")
        private String receiverId;

        private ChatSyncConfig(Builder builder) {
            this.IMAIAgentId = builder.IMAIAgentId;
            this.receiverId = builder.receiverId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ChatSyncConfig create() {
            return ChatSyncConfig.builder().build();
        }

        public String getIMAIAgentId() {
            return this.IMAIAgentId;
        }

        public String getReceiverId() {
            return this.receiverId;
        }

        public static final class Builder {
            private String IMAIAgentId;
            private String receiverId;

            private Builder() {
            }

            private Builder(ChatSyncConfig model) {
                this.IMAIAgentId = model.IMAIAgentId;
                this.receiverId = model.receiverId;
            }

            public Builder IMAIAgentId(String IMAIAgentId) {
                this.IMAIAgentId = IMAIAgentId;
                return this;
            }

            public Builder receiverId(String receiverId) {
                this.receiverId = receiverId;
                return this;
            }

            public ChatSyncConfig build() {
                return new ChatSyncConfig(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<GenerateAIAgentCallRequest, Builder> {
        private String AIAgentId;
        private AIAgentConfig agentConfig;
        private ChatSyncConfig chatSyncConfig;
        private Long expire;
        private String sessionId;
        private AIAgentTemplateConfig templateConfig;
        private String userData;
        private String userId;

        private Builder() {
        }

        private Builder(GenerateAIAgentCallRequest request) {
            super((Request)request);
            this.AIAgentId = request.AIAgentId;
            this.agentConfig = request.agentConfig;
            this.chatSyncConfig = request.chatSyncConfig;
            this.expire = request.expire;
            this.sessionId = request.sessionId;
            this.templateConfig = request.templateConfig;
            this.userData = request.userData;
            this.userId = request.userId;
        }

        public Builder AIAgentId(String AIAgentId) {
            this.putQueryParameter("AIAgentId", AIAgentId);
            this.AIAgentId = AIAgentId;
            return this;
        }

        public Builder agentConfig(AIAgentConfig agentConfig) {
            String agentConfigShrink = this.shrink((Object)agentConfig, "AgentConfig", "json");
            this.putQueryParameter("AgentConfig", agentConfigShrink);
            this.agentConfig = agentConfig;
            return this;
        }

        public Builder chatSyncConfig(ChatSyncConfig chatSyncConfig) {
            String chatSyncConfigShrink = this.shrink((Object)chatSyncConfig, "ChatSyncConfig", "json");
            this.putQueryParameter("ChatSyncConfig", chatSyncConfigShrink);
            this.chatSyncConfig = chatSyncConfig;
            return this;
        }

        public Builder expire(Long expire) {
            this.putQueryParameter("Expire", expire);
            this.expire = expire;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.putQueryParameter("SessionId", sessionId);
            this.sessionId = sessionId;
            return this;
        }

        public Builder templateConfig(AIAgentTemplateConfig templateConfig) {
            String templateConfigShrink = this.shrink((Object)templateConfig, "TemplateConfig", "json");
            this.putQueryParameter("TemplateConfig", templateConfigShrink);
            this.templateConfig = templateConfig;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public Builder userId(String userId) {
            this.putQueryParameter("UserId", userId);
            this.userId = userId;
            return this;
        }

        public GenerateAIAgentCallRequest build() {
            return new GenerateAIAgentCallRequest(this);
        }
    }
}

