/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListChannelAlertsRequest
extends Request {
    @Query
    @NameInMap(value="Category")
    private String category;
    @Query
    @NameInMap(value="GmtEnd")
    private String gmtEnd;
    @Query
    @NameInMap(value="GmtStart")
    private String gmtStart;
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="ResourceArn")
    @Validation(required=true)
    private String resourceArn;
    @Query
    @NameInMap(value="SortByModifiedTime")
    private String sortByModifiedTime;

    private ListChannelAlertsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.category = builder.category;
        this.gmtEnd = builder.gmtEnd;
        this.gmtStart = builder.gmtStart;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.resourceArn = builder.resourceArn;
        this.sortByModifiedTime = builder.sortByModifiedTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListChannelAlertsRequest create() {
        return ListChannelAlertsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCategory() {
        return this.category;
    }

    public String getGmtEnd() {
        return this.gmtEnd;
    }

    public String getGmtStart() {
        return this.gmtStart;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public String getSortByModifiedTime() {
        return this.sortByModifiedTime;
    }

    public static final class Builder
    extends Request.Builder<ListChannelAlertsRequest, Builder> {
        private String category;
        private String gmtEnd;
        private String gmtStart;
        private Integer pageNo;
        private Integer pageSize;
        private String resourceArn;
        private String sortByModifiedTime;

        private Builder() {
        }

        private Builder(ListChannelAlertsRequest request) {
            super((Request)request);
            this.category = request.category;
            this.gmtEnd = request.gmtEnd;
            this.gmtStart = request.gmtStart;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.resourceArn = request.resourceArn;
            this.sortByModifiedTime = request.sortByModifiedTime;
        }

        public Builder category(String category) {
            this.putQueryParameter("Category", category);
            this.category = category;
            return this;
        }

        public Builder gmtEnd(String gmtEnd) {
            this.putQueryParameter("GmtEnd", gmtEnd);
            this.gmtEnd = gmtEnd;
            return this;
        }

        public Builder gmtStart(String gmtStart) {
            this.putQueryParameter("GmtStart", gmtStart);
            this.gmtStart = gmtStart;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder resourceArn(String resourceArn) {
            this.putQueryParameter("ResourceArn", resourceArn);
            this.resourceArn = resourceArn;
            return this;
        }

        public Builder sortByModifiedTime(String sortByModifiedTime) {
            this.putQueryParameter("SortByModifiedTime", sortByModifiedTime);
            this.sortByModifiedTime = sortByModifiedTime;
            return this;
        }

        public ListChannelAlertsRequest build() {
            return new ListChannelAlertsRequest(this);
        }
    }
}

