/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListCustomTemplatesRequest
extends Request {
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="OrderBy")
    private String orderBy;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="Subtype")
    private String subtype;
    @Query
    @NameInMap(value="TemplateId")
    private String templateId;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private ListCustomTemplatesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.name = builder.name;
        this.orderBy = builder.orderBy;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.subtype = builder.subtype;
        this.templateId = builder.templateId;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListCustomTemplatesRequest create() {
        return ListCustomTemplatesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getName() {
        return this.name;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<ListCustomTemplatesRequest, Builder> {
        private String name;
        private String orderBy;
        private Integer pageNumber;
        private Integer pageSize;
        private String subtype;
        private String templateId;
        private String type;

        private Builder() {
        }

        private Builder(ListCustomTemplatesRequest request) {
            super((Request)request);
            this.name = request.name;
            this.orderBy = request.orderBy;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.subtype = request.subtype;
            this.templateId = request.templateId;
            this.type = request.type;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.putQueryParameter("OrderBy", orderBy);
            this.orderBy = orderBy;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder subtype(String subtype) {
            this.putQueryParameter("Subtype", subtype);
            this.subtype = subtype;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putQueryParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public ListCustomTemplatesRequest build() {
            return new ListCustomTemplatesRequest(this);
        }
    }
}

