/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListPublicMediaBasicInfosRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="BusinessType")
    private String businessType;
    @Query
    @NameInMap(value="IncludeFileBasicInfo")
    private Boolean includeFileBasicInfo;
    @Query
    @NameInMap(value="MaxResults")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer maxResults;
    @Query
    @NameInMap(value="MediaTagId")
    private String mediaTagId;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="PageNo")
    @Validation(maximum=2.147483647E9, minimum=1.0)
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;

    private ListPublicMediaBasicInfosRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.businessType = builder.businessType;
        this.includeFileBasicInfo = builder.includeFileBasicInfo;
        this.maxResults = builder.maxResults;
        this.mediaTagId = builder.mediaTagId;
        this.nextToken = builder.nextToken;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListPublicMediaBasicInfosRequest create() {
        return ListPublicMediaBasicInfosRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public Boolean getIncludeFileBasicInfo() {
        return this.includeFileBasicInfo;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public String getMediaTagId() {
        return this.mediaTagId;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<ListPublicMediaBasicInfosRequest, Builder> {
        private String regionId;
        private String businessType;
        private Boolean includeFileBasicInfo;
        private Integer maxResults;
        private String mediaTagId;
        private String nextToken;
        private Integer pageNo;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(ListPublicMediaBasicInfosRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.businessType = request.businessType;
            this.includeFileBasicInfo = request.includeFileBasicInfo;
            this.maxResults = request.maxResults;
            this.mediaTagId = request.mediaTagId;
            this.nextToken = request.nextToken;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder businessType(String businessType) {
            this.putQueryParameter("BusinessType", businessType);
            this.businessType = businessType;
            return this;
        }

        public Builder includeFileBasicInfo(Boolean includeFileBasicInfo) {
            this.putQueryParameter("IncludeFileBasicInfo", includeFileBasicInfo);
            this.includeFileBasicInfo = includeFileBasicInfo;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.putQueryParameter("MaxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder mediaTagId(String mediaTagId) {
            this.putQueryParameter("MediaTagId", mediaTagId);
            this.mediaTagId = mediaTagId;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListPublicMediaBasicInfosRequest build() {
            return new ListPublicMediaBasicInfosRequest(this);
        }
    }
}

