/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListSourceLocationsRequest
extends Request {
    @Query
    @NameInMap(value="FilterState")
    private Boolean filterState;
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;
    @Query
    @NameInMap(value="SortByModifiedTime")
    private String sortByModifiedTime;
    @Query
    @NameInMap(value="SourceLocationName")
    private String sourceLocationName;

    private ListSourceLocationsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.filterState = builder.filterState;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
        this.sortByModifiedTime = builder.sortByModifiedTime;
        this.sourceLocationName = builder.sourceLocationName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListSourceLocationsRequest create() {
        return ListSourceLocationsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getFilterState() {
        return this.filterState;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSortByModifiedTime() {
        return this.sortByModifiedTime;
    }

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    public static final class Builder
    extends Request.Builder<ListSourceLocationsRequest, Builder> {
        private Boolean filterState;
        private Integer pageNo;
        private Integer pageSize;
        private String sortBy;
        private String sortByModifiedTime;
        private String sourceLocationName;

        private Builder() {
        }

        private Builder(ListSourceLocationsRequest request) {
            super((Request)request);
            this.filterState = request.filterState;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
            this.sortByModifiedTime = request.sortByModifiedTime;
            this.sourceLocationName = request.sourceLocationName;
        }

        public Builder filterState(Boolean filterState) {
            this.putQueryParameter("FilterState", filterState);
            this.filterState = filterState;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortByModifiedTime(String sortByModifiedTime) {
            this.putQueryParameter("SortByModifiedTime", sortByModifiedTime);
            this.sortByModifiedTime = sortByModifiedTime;
            return this;
        }

        public Builder sourceLocationName(String sourceLocationName) {
            this.putQueryParameter("SourceLocationName", sourceLocationName);
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public ListSourceLocationsRequest build() {
            return new ListSourceLocationsRequest(this);
        }
    }
}

