/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListSourcesRequest
extends Request {
    @Query
    @NameInMap(value="FilterState")
    private Boolean filterState;
    @Query
    @NameInMap(value="PageNo")
    private String pageNo;
    @Query
    @NameInMap(value="PageSize")
    private String pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;
    @Query
    @NameInMap(value="SortByModifiedTime")
    private String sortByModifiedTime;
    @Query
    @NameInMap(value="SourceLocationName")
    private String sourceLocationName;
    @Query
    @NameInMap(value="SourceName")
    private String sourceName;
    @Query
    @NameInMap(value="SourceType")
    private String sourceType;

    private ListSourcesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.filterState = builder.filterState;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
        this.sortByModifiedTime = builder.sortByModifiedTime;
        this.sourceLocationName = builder.sourceLocationName;
        this.sourceName = builder.sourceName;
        this.sourceType = builder.sourceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListSourcesRequest create() {
        return ListSourcesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getFilterState() {
        return this.filterState;
    }

    public String getPageNo() {
        return this.pageNo;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSortByModifiedTime() {
        return this.sortByModifiedTime;
    }

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public static final class Builder
    extends Request.Builder<ListSourcesRequest, Builder> {
        private Boolean filterState;
        private String pageNo;
        private String pageSize;
        private String sortBy;
        private String sortByModifiedTime;
        private String sourceLocationName;
        private String sourceName;
        private String sourceType;

        private Builder() {
        }

        private Builder(ListSourcesRequest request) {
            super((Request)request);
            this.filterState = request.filterState;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
            this.sortByModifiedTime = request.sortByModifiedTime;
            this.sourceLocationName = request.sourceLocationName;
            this.sourceName = request.sourceName;
            this.sourceType = request.sourceType;
        }

        public Builder filterState(Boolean filterState) {
            this.putQueryParameter("FilterState", filterState);
            this.filterState = filterState;
            return this;
        }

        public Builder pageNo(String pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(String pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortByModifiedTime(String sortByModifiedTime) {
            this.putQueryParameter("SortByModifiedTime", sortByModifiedTime);
            this.sortByModifiedTime = sortByModifiedTime;
            return this;
        }

        public Builder sourceLocationName(String sourceLocationName) {
            this.putQueryParameter("SourceLocationName", sourceLocationName);
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.putQueryParameter("SourceName", sourceName);
            this.sourceName = sourceName;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.putQueryParameter("SourceType", sourceType);
            this.sourceType = sourceType;
            return this;
        }

        public ListSourcesRequest build() {
            return new ListSourcesRequest(this);
        }
    }
}

