/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.service.ice20201109.models.MediaObject;
import darabonba.core.TeaModel;

public class MediaConvertOutput
extends TeaModel {
    @NameInMap(value="Features")
    private String features;
    @NameInMap(value="Name")
    private String name;
    @NameInMap(value="OutputFile")
    private MediaObject outputFile;
    @NameInMap(value="OverrideParams")
    private String overrideParams;
    @NameInMap(value="Priority")
    @Validation(maximum=10.0, minimum=1.0)
    private Integer priority;
    @NameInMap(value="TemplateId")
    private String templateId;

    private MediaConvertOutput(Builder builder) {
        this.features = builder.features;
        this.name = builder.name;
        this.outputFile = builder.outputFile;
        this.overrideParams = builder.overrideParams;
        this.priority = builder.priority;
        this.templateId = builder.templateId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MediaConvertOutput create() {
        return MediaConvertOutput.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getFeatures() {
        return this.features;
    }

    public String getName() {
        return this.name;
    }

    public MediaObject getOutputFile() {
        return this.outputFile;
    }

    public String getOverrideParams() {
        return this.overrideParams;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public static final class Builder {
        private String features;
        private String name;
        private MediaObject outputFile;
        private String overrideParams;
        private Integer priority;
        private String templateId;

        private Builder() {
        }

        private Builder(MediaConvertOutput model) {
            this.features = model.features;
            this.name = model.name;
            this.outputFile = model.outputFile;
            this.overrideParams = model.overrideParams;
            this.priority = model.priority;
            this.templateId = model.templateId;
        }

        public Builder features(String features) {
            this.features = features;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder outputFile(MediaObject outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public Builder overrideParams(String overrideParams) {
            this.overrideParams = overrideParams;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public MediaConvertOutput build() {
            return new MediaConvertOutput(this);
        }
    }
}

