/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.ice20201109.models.AIAgentConfig;
import com.aliyun.sdk.service.ice20201109.models.AIAgentRuntimeConfig;
import com.aliyun.sdk.service.ice20201109.models.AIAgentTemplateConfig;
import darabonba.core.TeaModel;

public class StartAIAgentInstanceRequest
extends Request {
    @Query
    @NameInMap(value="AIAgentId")
    @Validation(required=true)
    private String AIAgentId;
    @Query
    @NameInMap(value="AgentConfig")
    private AIAgentConfig agentConfig;
    @Query
    @NameInMap(value="ChatSyncConfig")
    private ChatSyncConfig chatSyncConfig;
    @Query
    @NameInMap(value="RuntimeConfig")
    @Validation(required=true)
    private AIAgentRuntimeConfig runtimeConfig;
    @Query
    @NameInMap(value="SessionId")
    private String sessionId;
    @Query
    @NameInMap(value="TemplateConfig")
    @Deprecated
    private AIAgentTemplateConfig templateConfig;
    @Query
    @NameInMap(value="UserData")
    private String userData;

    private StartAIAgentInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.AIAgentId = builder.AIAgentId;
        this.agentConfig = builder.agentConfig;
        this.chatSyncConfig = builder.chatSyncConfig;
        this.runtimeConfig = builder.runtimeConfig;
        this.sessionId = builder.sessionId;
        this.templateConfig = builder.templateConfig;
        this.userData = builder.userData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StartAIAgentInstanceRequest create() {
        return StartAIAgentInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAIAgentId() {
        return this.AIAgentId;
    }

    public AIAgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public ChatSyncConfig getChatSyncConfig() {
        return this.chatSyncConfig;
    }

    public AIAgentRuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public AIAgentTemplateConfig getTemplateConfig() {
        return this.templateConfig;
    }

    public String getUserData() {
        return this.userData;
    }

    public static class ChatSyncConfig
    extends TeaModel {
        @NameInMap(value="IMAIAgentId")
        private String IMAIAgentId;
        @NameInMap(value="ReceiverId")
        private String receiverId;

        private ChatSyncConfig(Builder builder) {
            this.IMAIAgentId = builder.IMAIAgentId;
            this.receiverId = builder.receiverId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ChatSyncConfig create() {
            return ChatSyncConfig.builder().build();
        }

        public String getIMAIAgentId() {
            return this.IMAIAgentId;
        }

        public String getReceiverId() {
            return this.receiverId;
        }

        public static final class Builder {
            private String IMAIAgentId;
            private String receiverId;

            private Builder() {
            }

            private Builder(ChatSyncConfig model) {
                this.IMAIAgentId = model.IMAIAgentId;
                this.receiverId = model.receiverId;
            }

            public Builder IMAIAgentId(String IMAIAgentId) {
                this.IMAIAgentId = IMAIAgentId;
                return this;
            }

            public Builder receiverId(String receiverId) {
                this.receiverId = receiverId;
                return this;
            }

            public ChatSyncConfig build() {
                return new ChatSyncConfig(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<StartAIAgentInstanceRequest, Builder> {
        private String AIAgentId;
        private AIAgentConfig agentConfig;
        private ChatSyncConfig chatSyncConfig;
        private AIAgentRuntimeConfig runtimeConfig;
        private String sessionId;
        private AIAgentTemplateConfig templateConfig;
        private String userData;

        private Builder() {
        }

        private Builder(StartAIAgentInstanceRequest request) {
            super((Request)request);
            this.AIAgentId = request.AIAgentId;
            this.agentConfig = request.agentConfig;
            this.chatSyncConfig = request.chatSyncConfig;
            this.runtimeConfig = request.runtimeConfig;
            this.sessionId = request.sessionId;
            this.templateConfig = request.templateConfig;
            this.userData = request.userData;
        }

        public Builder AIAgentId(String AIAgentId) {
            this.putQueryParameter("AIAgentId", AIAgentId);
            this.AIAgentId = AIAgentId;
            return this;
        }

        public Builder agentConfig(AIAgentConfig agentConfig) {
            String agentConfigShrink = this.shrink((Object)agentConfig, "AgentConfig", "json");
            this.putQueryParameter("AgentConfig", agentConfigShrink);
            this.agentConfig = agentConfig;
            return this;
        }

        public Builder chatSyncConfig(ChatSyncConfig chatSyncConfig) {
            String chatSyncConfigShrink = this.shrink((Object)chatSyncConfig, "ChatSyncConfig", "json");
            this.putQueryParameter("ChatSyncConfig", chatSyncConfigShrink);
            this.chatSyncConfig = chatSyncConfig;
            return this;
        }

        public Builder runtimeConfig(AIAgentRuntimeConfig runtimeConfig) {
            String runtimeConfigShrink = this.shrink((Object)runtimeConfig, "RuntimeConfig", "json");
            this.putQueryParameter("RuntimeConfig", runtimeConfigShrink);
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.putQueryParameter("SessionId", sessionId);
            this.sessionId = sessionId;
            return this;
        }

        public Builder templateConfig(AIAgentTemplateConfig templateConfig) {
            String templateConfigShrink = this.shrink((Object)templateConfig, "TemplateConfig", "json");
            this.putQueryParameter("TemplateConfig", templateConfigShrink);
            this.templateConfig = templateConfig;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public StartAIAgentInstanceRequest build() {
            return new StartAIAgentInstanceRequest(this);
        }
    }
}

