/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class SubmitAIAgentVideoAuditTaskRequest
extends Request {
    @Query
    @NameInMap(value="AIAgentId")
    @Validation(required=true)
    private String AIAgentId;
    @Query
    @NameInMap(value="AuditInterval")
    private Integer auditInterval;
    @Query
    @NameInMap(value="CallbackConfig")
    private CallbackConfig callbackConfig;
    @Query
    @NameInMap(value="CapturePolicies")
    @Validation(required=true)
    private List<CapturePolicies> capturePolicies;
    @Query
    @NameInMap(value="Input")
    @Validation(required=true)
    private Input input;
    @Query
    @NameInMap(value="UserData")
    private String userData;

    private SubmitAIAgentVideoAuditTaskRequest(Builder builder) {
        super((Request.Builder)builder);
        this.AIAgentId = builder.AIAgentId;
        this.auditInterval = builder.auditInterval;
        this.callbackConfig = builder.callbackConfig;
        this.capturePolicies = builder.capturePolicies;
        this.input = builder.input;
        this.userData = builder.userData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SubmitAIAgentVideoAuditTaskRequest create() {
        return SubmitAIAgentVideoAuditTaskRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAIAgentId() {
        return this.AIAgentId;
    }

    public Integer getAuditInterval() {
        return this.auditInterval;
    }

    public CallbackConfig getCallbackConfig() {
        return this.callbackConfig;
    }

    public List<CapturePolicies> getCapturePolicies() {
        return this.capturePolicies;
    }

    public Input getInput() {
        return this.input;
    }

    public String getUserData() {
        return this.userData;
    }

    public static class Input
    extends TeaModel {
        @NameInMap(value="Media")
        private String media;
        @NameInMap(value="Type")
        private String type;

        private Input(Builder builder) {
            this.media = builder.media;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Input create() {
            return Input.builder().build();
        }

        public String getMedia() {
            return this.media;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String media;
            private String type;

            private Builder() {
            }

            private Builder(Input model) {
                this.media = model.media;
                this.type = model.type;
            }

            public Builder media(String media) {
                this.media = media;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Input build() {
                return new Input(this);
            }
        }
    }

    public static class CapturePolicies
    extends TeaModel {
        @NameInMap(value="Duration")
        private Integer duration;
        @NameInMap(value="FrameCount")
        private Integer frameCount;
        @NameInMap(value="Prompt")
        private String prompt;
        @NameInMap(value="StartTime")
        private Integer startTime;

        private CapturePolicies(Builder builder) {
            this.duration = builder.duration;
            this.frameCount = builder.frameCount;
            this.prompt = builder.prompt;
            this.startTime = builder.startTime;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static CapturePolicies create() {
            return CapturePolicies.builder().build();
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Integer getFrameCount() {
            return this.frameCount;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public static final class Builder {
            private Integer duration;
            private Integer frameCount;
            private String prompt;
            private Integer startTime;

            private Builder() {
            }

            private Builder(CapturePolicies model) {
                this.duration = model.duration;
                this.frameCount = model.frameCount;
                this.prompt = model.prompt;
                this.startTime = model.startTime;
            }

            public Builder duration(Integer duration) {
                this.duration = duration;
                return this;
            }

            public Builder frameCount(Integer frameCount) {
                this.frameCount = frameCount;
                return this;
            }

            public Builder prompt(String prompt) {
                this.prompt = prompt;
                return this;
            }

            public Builder startTime(Integer startTime) {
                this.startTime = startTime;
                return this;
            }

            public CapturePolicies build() {
                return new CapturePolicies(this);
            }
        }
    }

    public static class CallbackConfig
    extends TeaModel {
        @NameInMap(value="Token")
        private String token;
        @NameInMap(value="Url")
        private String url;

        private CallbackConfig(Builder builder) {
            this.token = builder.token;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static CallbackConfig create() {
            return CallbackConfig.builder().build();
        }

        public String getToken() {
            return this.token;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private String token;
            private String url;

            private Builder() {
            }

            private Builder(CallbackConfig model) {
                this.token = model.token;
                this.url = model.url;
            }

            public Builder token(String token) {
                this.token = token;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public CallbackConfig build() {
                return new CallbackConfig(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<SubmitAIAgentVideoAuditTaskRequest, Builder> {
        private String AIAgentId;
        private Integer auditInterval;
        private CallbackConfig callbackConfig;
        private List<CapturePolicies> capturePolicies;
        private Input input;
        private String userData;

        private Builder() {
        }

        private Builder(SubmitAIAgentVideoAuditTaskRequest request) {
            super((Request)request);
            this.AIAgentId = request.AIAgentId;
            this.auditInterval = request.auditInterval;
            this.callbackConfig = request.callbackConfig;
            this.capturePolicies = request.capturePolicies;
            this.input = request.input;
            this.userData = request.userData;
        }

        public Builder AIAgentId(String AIAgentId) {
            this.putQueryParameter("AIAgentId", AIAgentId);
            this.AIAgentId = AIAgentId;
            return this;
        }

        public Builder auditInterval(Integer auditInterval) {
            this.putQueryParameter("AuditInterval", auditInterval);
            this.auditInterval = auditInterval;
            return this;
        }

        public Builder callbackConfig(CallbackConfig callbackConfig) {
            String callbackConfigShrink = this.shrink((Object)callbackConfig, "CallbackConfig", "json");
            this.putQueryParameter("CallbackConfig", callbackConfigShrink);
            this.callbackConfig = callbackConfig;
            return this;
        }

        public Builder capturePolicies(List<CapturePolicies> capturePolicies) {
            String capturePoliciesShrink = this.shrink(capturePolicies, "CapturePolicies", "json");
            this.putQueryParameter("CapturePolicies", capturePoliciesShrink);
            this.capturePolicies = capturePolicies;
            return this;
        }

        public Builder input(Input input) {
            String inputShrink = this.shrink((Object)input, "Input", "json");
            this.putQueryParameter("Input", inputShrink);
            this.input = input;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public SubmitAIAgentVideoAuditTaskRequest build() {
            return new SubmitAIAgentVideoAuditTaskRequest(this);
        }
    }
}

