/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateAvatarTrainingJobRequest
extends Request {
    @Query
    @NameInMap(value="AvatarDescription")
    @Validation(maxLength=1024)
    private String avatarDescription;
    @Query
    @NameInMap(value="AvatarName")
    @Validation(maxLength=7)
    private String avatarName;
    @Query
    @NameInMap(value="JobId")
    @Validation(required=true)
    private String jobId;
    @Query
    @NameInMap(value="Portrait")
    @Validation(maxLength=32, minLength=32)
    private String portrait;
    @Query
    @NameInMap(value="Thumbnail")
    @Validation(maxLength=512)
    private String thumbnail;
    @Query
    @NameInMap(value="Transparent")
    private Boolean transparent;
    @Query
    @NameInMap(value="Video")
    @Validation(maxLength=32, minLength=32)
    private String video;

    private UpdateAvatarTrainingJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.avatarDescription = builder.avatarDescription;
        this.avatarName = builder.avatarName;
        this.jobId = builder.jobId;
        this.portrait = builder.portrait;
        this.thumbnail = builder.thumbnail;
        this.transparent = builder.transparent;
        this.video = builder.video;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateAvatarTrainingJobRequest create() {
        return UpdateAvatarTrainingJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAvatarDescription() {
        return this.avatarDescription;
    }

    public String getAvatarName() {
        return this.avatarName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getPortrait() {
        return this.portrait;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public Boolean getTransparent() {
        return this.transparent;
    }

    public String getVideo() {
        return this.video;
    }

    public static final class Builder
    extends Request.Builder<UpdateAvatarTrainingJobRequest, Builder> {
        private String avatarDescription;
        private String avatarName;
        private String jobId;
        private String portrait;
        private String thumbnail;
        private Boolean transparent;
        private String video;

        private Builder() {
        }

        private Builder(UpdateAvatarTrainingJobRequest request) {
            super((Request)request);
            this.avatarDescription = request.avatarDescription;
            this.avatarName = request.avatarName;
            this.jobId = request.jobId;
            this.portrait = request.portrait;
            this.thumbnail = request.thumbnail;
            this.transparent = request.transparent;
            this.video = request.video;
        }

        public Builder avatarDescription(String avatarDescription) {
            this.putQueryParameter("AvatarDescription", avatarDescription);
            this.avatarDescription = avatarDescription;
            return this;
        }

        public Builder avatarName(String avatarName) {
            this.putQueryParameter("AvatarName", avatarName);
            this.avatarName = avatarName;
            return this;
        }

        public Builder jobId(String jobId) {
            this.putQueryParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder portrait(String portrait) {
            this.putQueryParameter("Portrait", portrait);
            this.portrait = portrait;
            return this;
        }

        public Builder thumbnail(String thumbnail) {
            this.putQueryParameter("Thumbnail", thumbnail);
            this.thumbnail = thumbnail;
            return this;
        }

        public Builder transparent(Boolean transparent) {
            this.putQueryParameter("Transparent", transparent);
            this.transparent = transparent;
            return this;
        }

        public Builder video(String video) {
            this.putQueryParameter("Video", video);
            this.video = video;
            return this;
        }

        public UpdateAvatarTrainingJobRequest build() {
            return new UpdateAvatarTrainingJobRequest(this);
        }
    }
}

