/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateLiveRecordTemplateRequest
extends Request {
    @Body
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Body
    @NameInMap(value="RecordFormat")
    @Validation(required=true)
    private List<RecordFormat> recordFormat;
    @Body
    @NameInMap(value="TemplateId")
    @Validation(required=true)
    private String templateId;

    private UpdateLiveRecordTemplateRequest(Builder builder) {
        super((Request.Builder)builder);
        this.name = builder.name;
        this.recordFormat = builder.recordFormat;
        this.templateId = builder.templateId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateLiveRecordTemplateRequest create() {
        return UpdateLiveRecordTemplateRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getName() {
        return this.name;
    }

    public List<RecordFormat> getRecordFormat() {
        return this.recordFormat;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public static class RecordFormat
    extends TeaModel {
        @NameInMap(value="CycleDuration")
        private Integer cycleDuration;
        @NameInMap(value="Format")
        @Validation(required=true)
        private String format;
        @NameInMap(value="OssObjectPrefix")
        private String ossObjectPrefix;
        @NameInMap(value="SliceDuration")
        private Integer sliceDuration;
        @NameInMap(value="SliceOssObjectPrefix")
        private String sliceOssObjectPrefix;

        private RecordFormat(Builder builder) {
            this.cycleDuration = builder.cycleDuration;
            this.format = builder.format;
            this.ossObjectPrefix = builder.ossObjectPrefix;
            this.sliceDuration = builder.sliceDuration;
            this.sliceOssObjectPrefix = builder.sliceOssObjectPrefix;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RecordFormat create() {
            return RecordFormat.builder().build();
        }

        public Integer getCycleDuration() {
            return this.cycleDuration;
        }

        public String getFormat() {
            return this.format;
        }

        public String getOssObjectPrefix() {
            return this.ossObjectPrefix;
        }

        public Integer getSliceDuration() {
            return this.sliceDuration;
        }

        public String getSliceOssObjectPrefix() {
            return this.sliceOssObjectPrefix;
        }

        public static final class Builder {
            private Integer cycleDuration;
            private String format;
            private String ossObjectPrefix;
            private Integer sliceDuration;
            private String sliceOssObjectPrefix;

            private Builder() {
            }

            private Builder(RecordFormat model) {
                this.cycleDuration = model.cycleDuration;
                this.format = model.format;
                this.ossObjectPrefix = model.ossObjectPrefix;
                this.sliceDuration = model.sliceDuration;
                this.sliceOssObjectPrefix = model.sliceOssObjectPrefix;
            }

            public Builder cycleDuration(Integer cycleDuration) {
                this.cycleDuration = cycleDuration;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder ossObjectPrefix(String ossObjectPrefix) {
                this.ossObjectPrefix = ossObjectPrefix;
                return this;
            }

            public Builder sliceDuration(Integer sliceDuration) {
                this.sliceDuration = sliceDuration;
                return this;
            }

            public Builder sliceOssObjectPrefix(String sliceOssObjectPrefix) {
                this.sliceOssObjectPrefix = sliceOssObjectPrefix;
                return this;
            }

            public RecordFormat build() {
                return new RecordFormat(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateLiveRecordTemplateRequest, Builder> {
        private String name;
        private List<RecordFormat> recordFormat;
        private String templateId;

        private Builder() {
        }

        private Builder(UpdateLiveRecordTemplateRequest request) {
            super((Request)request);
            this.name = request.name;
            this.recordFormat = request.recordFormat;
            this.templateId = request.templateId;
        }

        public Builder name(String name) {
            this.putBodyParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder recordFormat(List<RecordFormat> recordFormat) {
            String recordFormatShrink = this.shrink(recordFormat, "RecordFormat", "json");
            this.putBodyParameter("RecordFormat", recordFormatShrink);
            this.recordFormat = recordFormat;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putBodyParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public UpdateLiveRecordTemplateRequest build() {
            return new UpdateLiveRecordTemplateRequest(this);
        }
    }
}

