/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateSourceLocationRequest
extends Request {
    @Query
    @NameInMap(value="BaseUrl")
    private String baseUrl;
    @Query
    @NameInMap(value="EnableSegmentDelivery")
    private Boolean enableSegmentDelivery;
    @Query
    @NameInMap(value="SegmentDeliveryUrl")
    private String segmentDeliveryUrl;
    @Query
    @NameInMap(value="SourceLocationName")
    @Validation(required=true)
    private String sourceLocationName;

    private UpdateSourceLocationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.baseUrl = builder.baseUrl;
        this.enableSegmentDelivery = builder.enableSegmentDelivery;
        this.segmentDeliveryUrl = builder.segmentDeliveryUrl;
        this.sourceLocationName = builder.sourceLocationName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateSourceLocationRequest create() {
        return UpdateSourceLocationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean getEnableSegmentDelivery() {
        return this.enableSegmentDelivery;
    }

    public String getSegmentDeliveryUrl() {
        return this.segmentDeliveryUrl;
    }

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    public static final class Builder
    extends Request.Builder<UpdateSourceLocationRequest, Builder> {
        private String baseUrl;
        private Boolean enableSegmentDelivery;
        private String segmentDeliveryUrl;
        private String sourceLocationName;

        private Builder() {
        }

        private Builder(UpdateSourceLocationRequest request) {
            super((Request)request);
            this.baseUrl = request.baseUrl;
            this.enableSegmentDelivery = request.enableSegmentDelivery;
            this.segmentDeliveryUrl = request.segmentDeliveryUrl;
            this.sourceLocationName = request.sourceLocationName;
        }

        public Builder baseUrl(String baseUrl) {
            this.putQueryParameter("BaseUrl", baseUrl);
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder enableSegmentDelivery(Boolean enableSegmentDelivery) {
            this.putQueryParameter("EnableSegmentDelivery", enableSegmentDelivery);
            this.enableSegmentDelivery = enableSegmentDelivery;
            return this;
        }

        public Builder segmentDeliveryUrl(String segmentDeliveryUrl) {
            this.putQueryParameter("SegmentDeliveryUrl", segmentDeliveryUrl);
            this.segmentDeliveryUrl = segmentDeliveryUrl;
            return this;
        }

        public Builder sourceLocationName(String sourceLocationName) {
            this.putQueryParameter("SourceLocationName", sourceLocationName);
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public UpdateSourceLocationRequest build() {
            return new UpdateSourceLocationRequest(this);
        }
    }
}

