/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import darabonba.core.TeaModel;
import java.util.List;

public class VodPackagingConfig
extends TeaModel {
    @NameInMap(value="DrmProvider")
    private DrmProvider drmProvider;
    @NameInMap(value="ManifestName")
    private String manifestName;
    @NameInMap(value="SegmentDuration")
    private Long segmentDuration;
    @NameInMap(value="StreamSelection")
    private StreamSelection streamSelection;

    private VodPackagingConfig(Builder builder) {
        this.drmProvider = builder.drmProvider;
        this.manifestName = builder.manifestName;
        this.segmentDuration = builder.segmentDuration;
        this.streamSelection = builder.streamSelection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VodPackagingConfig create() {
        return VodPackagingConfig.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public DrmProvider getDrmProvider() {
        return this.drmProvider;
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public Long getSegmentDuration() {
        return this.segmentDuration;
    }

    public StreamSelection getStreamSelection() {
        return this.streamSelection;
    }

    public static class StreamSelection
    extends TeaModel {
        @NameInMap(value="MaxVideoBitsPerSecond")
        private Long maxVideoBitsPerSecond;
        @NameInMap(value="MinVideoBitsPerSecond")
        private Long minVideoBitsPerSecond;
        @NameInMap(value="StreamOrder")
        private String streamOrder;

        private StreamSelection(Builder builder) {
            this.maxVideoBitsPerSecond = builder.maxVideoBitsPerSecond;
            this.minVideoBitsPerSecond = builder.minVideoBitsPerSecond;
            this.streamOrder = builder.streamOrder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static StreamSelection create() {
            return StreamSelection.builder().build();
        }

        public Long getMaxVideoBitsPerSecond() {
            return this.maxVideoBitsPerSecond;
        }

        public Long getMinVideoBitsPerSecond() {
            return this.minVideoBitsPerSecond;
        }

        public String getStreamOrder() {
            return this.streamOrder;
        }

        public static final class Builder {
            private Long maxVideoBitsPerSecond;
            private Long minVideoBitsPerSecond;
            private String streamOrder;

            private Builder() {
            }

            private Builder(StreamSelection model) {
                this.maxVideoBitsPerSecond = model.maxVideoBitsPerSecond;
                this.minVideoBitsPerSecond = model.minVideoBitsPerSecond;
                this.streamOrder = model.streamOrder;
            }

            public Builder maxVideoBitsPerSecond(Long maxVideoBitsPerSecond) {
                this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
                return this;
            }

            public Builder minVideoBitsPerSecond(Long minVideoBitsPerSecond) {
                this.minVideoBitsPerSecond = minVideoBitsPerSecond;
                return this;
            }

            public Builder streamOrder(String streamOrder) {
                this.streamOrder = streamOrder;
                return this;
            }

            public StreamSelection build() {
                return new StreamSelection(this);
            }
        }
    }

    public static class DrmProvider
    extends TeaModel {
        @NameInMap(value="EncryptionMethod")
        private String encryptionMethod;
        @NameInMap(value="IV")
        private String iv;
        @NameInMap(value="SystemIds")
        private List<String> systemIds;
        @NameInMap(value="Url")
        private String url;

        private DrmProvider(Builder builder) {
            this.encryptionMethod = builder.encryptionMethod;
            this.iv = builder.iv;
            this.systemIds = builder.systemIds;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DrmProvider create() {
            return DrmProvider.builder().build();
        }

        public String getEncryptionMethod() {
            return this.encryptionMethod;
        }

        public String getIv() {
            return this.iv;
        }

        public List<String> getSystemIds() {
            return this.systemIds;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private String encryptionMethod;
            private String iv;
            private List<String> systemIds;
            private String url;

            private Builder() {
            }

            private Builder(DrmProvider model) {
                this.encryptionMethod = model.encryptionMethod;
                this.iv = model.iv;
                this.systemIds = model.systemIds;
                this.url = model.url;
            }

            public Builder encryptionMethod(String encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
                return this;
            }

            public Builder iv(String iv) {
                this.iv = iv;
                return this;
            }

            public Builder systemIds(List<String> systemIds) {
                this.systemIds = systemIds;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public DrmProvider build() {
                return new DrmProvider(this);
            }
        }
    }

    public static final class Builder {
        private DrmProvider drmProvider;
        private String manifestName;
        private Long segmentDuration;
        private StreamSelection streamSelection;

        private Builder() {
        }

        private Builder(VodPackagingConfig model) {
            this.drmProvider = model.drmProvider;
            this.manifestName = model.manifestName;
            this.segmentDuration = model.segmentDuration;
            this.streamSelection = model.streamSelection;
        }

        public Builder drmProvider(DrmProvider drmProvider) {
            this.drmProvider = drmProvider;
            return this;
        }

        public Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public Builder segmentDuration(Long segmentDuration) {
            this.segmentDuration = segmentDuration;
            return this;
        }

        public Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public VodPackagingConfig build() {
            return new VodPackagingConfig(this);
        }
    }
}

