/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client;

import com.aliyuncs.kms.secretsmanager.client.CacheClientBuilder;
import com.aliyuncs.kms.secretsmanager.client.SecretCacheClient;
import com.aliyuncs.kms.secretsmanager.client.cache.CacheSecretStoreStrategy;
import com.aliyuncs.kms.secretsmanager.client.cache.DefaultSecretCacheHook;
import com.aliyuncs.kms.secretsmanager.client.cache.MemoryCacheSecretStoreStrategy;
import com.aliyuncs.kms.secretsmanager.client.cache.SecretCacheHook;
import com.aliyuncs.kms.secretsmanager.client.exception.CacheSecretException;
import com.aliyuncs.kms.secretsmanager.client.service.BaseSecretManagerClientBuilder;
import com.aliyuncs.kms.secretsmanager.client.service.DefaultRefreshSecretStrategy;
import com.aliyuncs.kms.secretsmanager.client.service.RefreshSecretStrategy;
import com.aliyuncs.kms.secretsmanager.client.service.SecretManagerClient;
import com.aliyuncs.kms.secretsmanager.client.utils.CommonLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretCacheClientBuilder
implements CacheClientBuilder<SecretCacheClient> {
    private SecretCacheClient secretCacheClient;

    public static SecretCacheClient newClient() throws CacheSecretException {
        SecretCacheClientBuilder builder = new SecretCacheClientBuilder();
        return builder.build();
    }

    public static SecretCacheClientBuilder newCacheClientBuilder(SecretManagerClient client) {
        SecretCacheClientBuilder builder = new SecretCacheClientBuilder();
        builder.buildSecretCacheClient();
        builder.secretCacheClient.secretClient = client;
        return builder;
    }

    public SecretCacheClientBuilder withSecretTTL(String secretName, long ttl) {
        this.buildSecretCacheClient();
        this.secretCacheClient.secretTTLMap.put(secretName, ttl);
        return this;
    }

    public SecretCacheClientBuilder withParseJSONTTL(String jsonTTLPropertyName) {
        this.buildSecretCacheClient();
        this.secretCacheClient.jsonTTLPropertyName = jsonTTLPropertyName;
        return this;
    }

    public SecretCacheClientBuilder withRefreshSecretStrategy(RefreshSecretStrategy refreshSecretStrategy) {
        this.buildSecretCacheClient();
        this.secretCacheClient.refreshSecretStrategy = refreshSecretStrategy;
        return this;
    }

    public SecretCacheClientBuilder withCacheSecretStrategy(CacheSecretStoreStrategy cacheSecretStrategy) {
        this.buildSecretCacheClient();
        this.secretCacheClient.cacheSecretStoreStrategy = cacheSecretStrategy;
        return this;
    }

    public SecretCacheClientBuilder withCacheStage(String stage) {
        this.buildSecretCacheClient();
        this.secretCacheClient.stage = stage;
        return this;
    }

    public SecretCacheClientBuilder withSecretCacheHook(SecretCacheHook hook) {
        this.buildSecretCacheClient();
        this.secretCacheClient.cacheHook = hook;
        return this;
    }

    public SecretCacheClientBuilder withLogger(Logger logger) {
        CommonLogger.registerLogger("CacheClient", logger);
        return this;
    }

    @Override
    public SecretCacheClient build() throws CacheSecretException {
        this.buildSecretCacheClient();
        if (!CommonLogger.isRegistered("CacheClient")) {
            CommonLogger.registerLogger("CacheClient", LoggerFactory.getLogger((String)"CacheClient"));
        }
        if (this.secretCacheClient.secretClient == null) {
            this.secretCacheClient.secretClient = BaseSecretManagerClientBuilder.standard().build();
        }
        if (this.secretCacheClient.cacheSecretStoreStrategy == null) {
            this.secretCacheClient.cacheSecretStoreStrategy = new MemoryCacheSecretStoreStrategy();
        }
        if (this.secretCacheClient.refreshSecretStrategy == null) {
            this.secretCacheClient.refreshSecretStrategy = new DefaultRefreshSecretStrategy(this.secretCacheClient.jsonTTLPropertyName);
        }
        if (this.secretCacheClient.cacheHook == null) {
            this.secretCacheClient.cacheHook = new DefaultSecretCacheHook(this.secretCacheClient.stage);
        }
        this.secretCacheClient.init();
        CommonLogger.getCommonLogger("CacheClient").infof("SecretCacheClientBuilder build success", new Object[0]);
        return this.secretCacheClient;
    }

    private void buildSecretCacheClient() {
        if (this.secretCacheClient == null) {
            this.secretCacheClient = new SecretCacheClient();
        }
    }
}

