/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.DateUtil;
import com.aliyun.sdk.gateway.oss.exception.OSSServerException;
import darabonba.core.TeaResponse;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import java.util.Date;

public class AdjustClockSkew
implements ResponseInterceptor {
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        OSSServerException exception;
        TeaResponse response = context.teaResponse();
        if (!response.success() && response.httpResponse().getStatusCode() == 403 && response.exception() instanceof OSSServerException && "RequestTimeTooSkewed".equals((exception = (OSSServerException)((Object)response.exception())).errorDetails().errorCode())) {
            try {
                Date requestTime = DateUtil.parseIso8601Date((String)exception.errorDetails().getErrorField("RequestTime"));
                Date serverTime = DateUtil.parseIso8601Date((String)exception.errorDetails().getErrorField("ServerTime"));
                Long timeOffset = serverTime.getTime() - requestTime.getTime();
                context.configuration().clientConfiguration().setOption(ClientOption.CLOCK_SKEW_DIFF, (Object)timeOffset);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return response;
    }
}

