/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.core.io.BoundedInputStream;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.internal.CRC64;
import com.aliyun.sdk.gateway.oss.internal.async.StoredSeparatelyHttpResponseHandler;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import darabonba.core.TeaRequestBody;
import darabonba.core.async.AsyncRequestBody;
import darabonba.core.async.AsyncResponseHandler;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.sync.RequestBody;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;

public class MakeMutableHttpRequestInterceptor
implements HttpRequestInterceptor {
    public HttpRequest modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        HttpRequest httpRequest = new HttpRequest(context.teaRequest().method(), "http://default");
        httpRequest.getHeaders().putAll(context.teaRequest().headers());
        TeaRequestBody body = (TeaRequestBody)attributes.get(AttributeKey.REQUEST_BODY);
        Long bodyLen = (Long)attributes.get(AttributeKey.REQUEST_BODY_LENGTH);
        boolean enableCRC64 = Boolean.TRUE.equals(attributes.get(AttributeKey.ENABLE_CHECKSUM_CRC64));
        if (body instanceof RequestBody) {
            RequestBody rBody = (RequestBody)body;
            InputStream stream = rBody.newStream();
            if (bodyLen != null) {
                stream = new BoundedInputStream(stream, bodyLen.longValue());
            }
            if (enableCRC64) {
                stream = new CheckedInputStream(stream, new CRC64());
            }
            httpRequest.setStreamBody(stream);
        } else if (body instanceof AsyncRequestBody) {
            // empty if block
        }
        if (context.teaResponseHandler() instanceof AsyncResponseHandler) {
            attributes.put((AttributeMap.Key)darabonba.core.internal.AttributeKey.HTTP_RESPONSE_HANDLER, (Object)this.getHttpResponseHandler(context, attributes));
        }
        return httpRequest;
    }

    private HttpResponseHandler getHttpResponseHandler(InterceptorContext context, AttributeMap attributes) {
        if (attributes.containsKey(AttributeKey.OSS_HTTP_RESPONSE_HANDLER)) {
            return new StoredSeparatelyHttpResponseHandler((HttpResponseHandler)attributes.get(AttributeKey.OSS_HTTP_RESPONSE_HANDLER));
        }
        if (attributes.containsKey(AttributeKey.OSS_ASYNC_RESPONSE_HANDLER)) {
            return new StoredSeparatelyHttpResponseHandler((AsyncResponseHandler)attributes.get(AttributeKey.OSS_ASYNC_RESPONSE_HANDLER));
        }
        return new StoredSeparatelyHttpResponseHandler((AsyncResponseHandler)context.teaResponseHandler());
    }
}

