package com.aliyun.sdk.gateway.pop.interceptor.response;

import com.aliyun.core.http.BodyType;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.ParseUtil;
import com.aliyun.core.utils.StringUtils;
import darabonba.core.TeaResponse;
import darabonba.core.exception.TeaException;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.utils.CommonUtil;

import java.io.ByteArrayInputStream;

public class PopResInterceptor implements ResponseInterceptor {
    private final ClientLogger logger = new ClientLogger(PopResInterceptor.class);

    @Override
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        logger.verbose("PopResponse process begin.");
        TeaResponse teaResponse = context.teaResponse();
        if (teaResponse.success()) {
            HttpResponse httpResponse = teaResponse.httpResponse();
            Object response = null;
            String bodyStr;
            try {
                switch (context.teaRequest().bodyType()) {
                    case BodyType.BYTE:
                        response = httpResponse.getBodyAsByteArray();
                        break;
                    case BodyType.BINARY:
                        byte[] bytes = httpResponse.getBodyAsByteArray();
                        response = new ByteArrayInputStream(bytes);
                        break;
                    case BodyType.JSON:
                        bodyStr = httpResponse.getBodyAsString();
                        if (!StringUtils.isEmpty(bodyStr)) {
                            response = CommonUtil.assertAsMap(ParseUtil.readAsJSON(bodyStr));
                        }
                        break;
                    case BodyType.ARRAY:
                        bodyStr = httpResponse.getBodyAsString();
                        if (!StringUtils.isEmpty(bodyStr)) {
                            response = CommonUtil.assertAsArray(ParseUtil.readAsJSON(httpResponse.getBodyAsString()));
                        }
                        break;
                    default:
                        bodyStr = httpResponse.getBodyAsString();
                        response = bodyStr;
                }
                teaResponse.setDeserializedBody(response);
            } catch (Exception e) {
                teaResponse.setException(new TeaException("Process response body error!", e));
            } finally {
                httpResponse.close();
            }
        }
        return teaResponse;
    }
}
