/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http.clients;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.HttpClientConnectionManager;

public class ApacheIdleConnectionCleaner
extends Thread {
    private static final Log LOG = LogFactory.getLog(ApacheIdleConnectionCleaner.class);
    private static final int PERIOD_SEC = 60;
    private static volatile ApacheIdleConnectionCleaner instance;
    private static final Map<HttpClientConnectionManager, Long> CONNMGRMAP;
    private volatile boolean isShuttingDown;

    private ApacheIdleConnectionCleaner() {
        super("sdk-apache-idle-connection-cleaner");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerConnectionManager(HttpClientConnectionManager connMgr, Long idleTimeMills) {
        if (instance == null) {
            Class<ApacheIdleConnectionCleaner> clazz = ApacheIdleConnectionCleaner.class;
            // MONITORENTER : com.aliyuncs.http.clients.ApacheIdleConnectionCleaner.class
            if (instance == null) {
                instance = new ApacheIdleConnectionCleaner();
                instance.start();
            }
            // MONITOREXIT : clazz
        }
        CONNMGRMAP.put(connMgr, idleTimeMills);
    }

    public static void removeConnectionManager(HttpClientConnectionManager connectionManager) {
        CONNMGRMAP.remove(connectionManager);
        if (CONNMGRMAP.isEmpty()) {
            ApacheIdleConnectionCleaner.shutdown();
        }
    }

    public static void shutdown() {
        if (instance != null) {
            ApacheIdleConnectionCleaner.instance.isShuttingDown = true;
            instance.interrupt();
            CONNMGRMAP.clear();
            instance = null;
        }
    }

    @Override
    public void run() {
        block4: while (true) {
            if (this.isShuttingDown) {
                LOG.debug((Object)"Shutting down.");
                return;
            }
            try {
                Thread.sleep(60000L);
                Iterator<Map.Entry<HttpClientConnectionManager, Long>> i$ = CONNMGRMAP.entrySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block4;
                    Map.Entry<HttpClientConnectionManager, Long> entry = i$.next();
                    try {
                        entry.getKey().closeIdleConnections(entry.getValue().longValue(), TimeUnit.MILLISECONDS);
                    }
                    catch (Exception t) {
                        LOG.warn((Object)"close idle connections failed", (Throwable)t);
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"interrupted.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    static {
        CONNMGRMAP = new ConcurrentHashMap<HttpClientConnectionManager, Long>();
    }
}

