/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.UserAgentConfig;
import com.aliyuncs.http.clients.CompatibleUrlConnClient;
import com.aliyuncs.utils.AuthUtils;
import com.aliyuncs.utils.ParameterHelper;
import com.aliyuncs.utils.StringUtils;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OIDCCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private String roleArn;
    private String oidcProviderArn;
    private String oidcTokenFilePath;
    private String roleSessionName;
    private String policy;
    private String stsEndpoint;
    private long durationSeconds;
    private BasicSessionCredentials credentials;

    String getRoleArn() {
        return this.roleArn;
    }

    void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    String getOidcProviderArn() {
        return this.oidcProviderArn;
    }

    void setOidcProviderArn(String oidcProviderArn) {
        this.oidcProviderArn = oidcProviderArn;
    }

    String getOidcTokenFilePath() {
        return this.oidcTokenFilePath;
    }

    void setOidcTokenFilePath(String oidcTokenFilePath) {
        this.oidcTokenFilePath = oidcTokenFilePath;
    }

    String getRoleSessionName() {
        return this.roleSessionName;
    }

    void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    String getPolicy() {
        return this.policy;
    }

    void setPolicy(String policy) {
        this.policy = policy;
    }

    public OIDCCredentialsProvider(String roleArn, String providerArn, String oidcTokenFilePath, String roleSessionName, String regionId) throws ClientException {
        String string = this.roleArn = !StringUtils.isEmpty(roleArn) ? roleArn : System.getenv("ALIBABA_CLOUD_ROLE_ARN");
        if (StringUtils.isEmpty(this.roleArn)) {
            throw new ClientException("roleArn does not exist and env ALIBABA_CLOUD_ROLE_ARN is null.");
        }
        String string2 = this.oidcProviderArn = !StringUtils.isEmpty(providerArn) ? providerArn : System.getenv("ALIBABA_CLOUD_OIDC_PROVIDER_ARN");
        if (StringUtils.isEmpty(this.oidcProviderArn)) {
            throw new ClientException("OIDCProviderArn does not exist and env ALIBABA_CLOUD_OIDC_PROVIDER_ARN is null.");
        }
        String string3 = this.oidcTokenFilePath = !StringUtils.isEmpty(oidcTokenFilePath) ? oidcTokenFilePath : System.getenv("ALIBABA_CLOUD_OIDC_TOKEN_FILE");
        if (StringUtils.isEmpty(this.oidcTokenFilePath)) {
            throw new ClientException("OIDCTokenFilePath does not exist and env ALIBABA_CLOUD_OIDC_TOKEN_FILE is null.");
        }
        String string4 = this.roleSessionName = !StringUtils.isEmpty(roleSessionName) ? roleSessionName : System.getenv("ALIBABA_CLOUD_ROLE_SESSION_NAME");
        if (StringUtils.isEmpty(this.roleSessionName)) {
            this.roleSessionName = "DEFAULT_ROLE_SESSION_NAME_FOR_JAVA_SDK_V1";
        }
        this.stsEndpoint = StringUtils.isEmpty(regionId) ? "https://sts.aliyuncs.com/" : String.format("https://sts.%s.aliyuncs.com/", regionId);
        this.durationSeconds = 3600L;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException, ServerException {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            String body = this.invokeAssumeRoleWithOIDC();
            this.credentials = OIDCCredentialsProvider.parseCredentials(body, this.durationSeconds);
        }
        return this.credentials;
    }

    private static BasicSessionCredentials parseCredentials(String body, long durationSeconds) throws ClientException {
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(body, Map.class);
        if (null == map) {
            throw new ClientException("Invalid JSON");
        }
        if (map.containsKey("Credentials")) {
            Map result = (Map)map.get("Credentials");
            String accessKeyId = (String)result.get("AccessKeyId");
            String accessKeySecret = (String)result.get("AccessKeySecret");
            String securityToken = (String)result.get("SecurityToken");
            return new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken, durationSeconds);
        }
        throw new ClientException("AssumeRoleWithOIDC failed: " + body);
    }

    private String invokeAssumeRoleWithOIDC() throws ClientException {
        HttpResponse response;
        String url;
        HashMap<String, String> queries = new HashMap<String, String>();
        queries.put("Action", "AssumeRoleWithOIDC");
        queries.put("Format", "JSON");
        queries.put("Version", "2015-04-01");
        queries.put("Timestamp", ParameterHelper.getISO8601Time(new Date()));
        try {
            url = this.stsEndpoint + "?" + new String(ParameterHelper.getFormData(queries));
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("AssumeRoleWithOIDC failed " + e.toString());
        }
        HttpRequest httpRequest = new HttpRequest(url);
        httpRequest.setSysMethod(MethodType.POST);
        httpRequest.setHttpContentType(FormatType.FORM);
        httpRequest.setSysConnectTimeout(1000);
        httpRequest.setSysReadTimeout(3000);
        httpRequest.putHeaderParameter("UserAgent", UserAgentConfig.resolve(null, null));
        String oidcToken = AuthUtils.readFile(this.oidcTokenFilePath);
        if (oidcToken == null) {
            throw new ClientException("Read OIDC token failed");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("DurationSeconds", String.valueOf(this.durationSeconds));
        body.put("RoleArn", this.roleArn);
        body.put("OIDCProviderArn", this.oidcProviderArn);
        body.put("OIDCToken", oidcToken);
        body.put("RoleSessionName", this.roleSessionName);
        body.put("Policy", this.policy);
        StringBuilder content = new StringBuilder();
        try {
            boolean first = true;
            for (Map.Entry entry : body.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
                if (first) {
                    first = false;
                } else {
                    content.append("&");
                }
                content.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
                content.append("=");
                content.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            httpRequest.setHttpContent(content.toString().getBytes("UTF-8"), "UTF-8", FormatType.FORM);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("AssumeRoleWithOIDC failed " + e.toString());
        }
        try {
            response = CompatibleUrlConnClient.compatibleGetResponse(httpRequest);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        if (response.getStatus() != 200) {
            String responseBody = response.getHttpContentString();
            Gson gson = new Gson();
            Map map = (Map)gson.fromJson(responseBody, Map.class);
            String requestID = (String)map.get("RequestId");
            String message = String.format("%s(RequestID: %s, Code: %s)", (String)map.get("Message"), requestID, (String)map.get("Code"));
            throw new ClientException("AssumeRoleWithOIDC failed: " + message);
        }
        return new String(response.getHttpContent());
    }
}

