/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.utils.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;

public class HttpUtil {
    private static final Log log;
    private static Boolean isHttpDebug;
    private static Boolean isHttpContentDebug;

    public static Boolean getIsHttpDebug() {
        return isHttpDebug;
    }

    public static void setIsHttpDebug(Boolean isHttpDebug) {
        HttpUtil.isHttpDebug = isHttpDebug;
    }

    public static Boolean getIsHttpContentDebug() {
        return isHttpContentDebug;
    }

    public static void setIsHttpContentDebug(Boolean isHttpContentDebug) {
        HttpUtil.isHttpContentDebug = isHttpContentDebug;
    }

    public static String debugHttpRequest(HttpRequest request) {
        if (isHttpDebug.booleanValue()) {
            StringBuilder debugString = new StringBuilder();
            String sysUrl = request.getSysUrl();
            try {
                URL url = new URL(sysUrl);
                debugString.append("> " + (Object)((Object)request.getSysMethod()) + " " + url.getProtocol().toUpperCase() + "/1.1\n> ");
                debugString.append("Host : " + url.getHost() + "\n> ");
            }
            catch (MalformedURLException e) {
                debugString.append("> " + (Object)((Object)request.getSysMethod()) + " " + sysUrl + "\n> ");
                debugString.append("Host : " + sysUrl + "\n> ");
            }
            Map<String, String> requestHeaders = request.getSysHeaders();
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                debugString.append(entry.getKey() + " : " + entry.getValue() + "\n> ");
            }
            debugString.append("Request URL : " + sysUrl + "\n> ");
            debugString.append("Request string to sign: [" + request.getSysStrToSign() + "]\n> ");
            debugString.append("Request isIgnoreSSLCerts : " + request.isIgnoreSSLCerts() + "\n> ");
            debugString.append("Request connect timeout : " + request.getSysConnectTimeout() + "\n> ");
            debugString.append("Request read timeout : " + request.getSysReadTimeout() + "\n> ");
            debugString.append("Encoding : " + request.getSysEncoding() + "\n> ");
            if (isHttpContentDebug.booleanValue()) {
                try {
                    debugString.append("\n" + request.getHttpContentString());
                }
                catch (ClientException e) {
                    debugString.append("\nCan not parse request content due to unsupported encoding : " + request.getSysEncoding());
                }
            }
            log.info((Object)("\n" + debugString));
            return debugString.toString();
        }
        return null;
    }

    public static String debugHttpResponse(HttpResponse response) {
        if (isHttpDebug.booleanValue()) {
            StringBuilder debugString = new StringBuilder();
            String protocol = "HTTP/1.1";
            debugString.append("< " + protocol + " " + response.getStatus() + "\n< ");
            Map<String, String> responseHeaders = response.getSysHeaders();
            for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
                debugString.append(entry.getKey() + " : " + entry.getValue() + "\n< ");
            }
            if (isHttpContentDebug.booleanValue()) {
                try {
                    debugString.append("\n" + response.getHttpContentString());
                }
                catch (ClientException e) {
                    debugString.append("\nCan not parse response due to unsupported encoding : " + response.getSysEncoding());
                }
            }
            log.info((Object)("\n" + debugString));
            return debugString.toString();
        }
        return null;
    }

    public static Proxy getJDKProxy(String clientProxy, String envProxy, HttpRequest request) throws ClientException {
        Proxy proxy = Proxy.NO_PROXY;
        try {
            String proxyStr;
            String string = proxyStr = !StringUtils.isEmpty(clientProxy) ? clientProxy : envProxy;
            if (StringUtils.isEmpty(proxyStr)) {
                return proxy;
            }
            URL proxyUrl = new URL(proxyStr);
            String userInfo = proxyUrl.getUserInfo();
            if (userInfo != null) {
                byte[] bytes = userInfo.getBytes("UTF-8");
                String auth = DatatypeConverter.printBase64Binary((byte[])bytes);
                request.putHeaderParameter("Proxy-Authorization", "Basic " + auth);
            }
            String hostname = proxyUrl.getHost();
            int port = proxyUrl.getPort();
            if (port == -1) {
                port = proxyUrl.getDefaultPort();
            }
            InetSocketAddress addr = new InetSocketAddress(hostname, port);
            proxy = new Proxy(Proxy.Type.HTTP, addr);
        }
        catch (IOException e) {
            throw new ClientException("SDK.InvalidProxy", "proxy url is invalid");
        }
        return proxy;
    }

    public static HttpHost getApacheProxy(String clientProxy, String envProxy, HttpRequest request) throws ClientException {
        try {
            String proxyStr;
            String string = proxyStr = !StringUtils.isEmpty(clientProxy) ? clientProxy : envProxy;
            if (StringUtils.isEmpty(proxyStr)) {
                return null;
            }
            URL proxyUrl = new URL(proxyStr);
            String userInfo = proxyUrl.getUserInfo();
            if (userInfo != null) {
                byte[] bytes = userInfo.getBytes("UTF-8");
                String auth = DatatypeConverter.printBase64Binary((byte[])bytes);
                request.putHeaderParameter("Proxy-Authorization", "Basic " + auth);
            }
            return new HttpHost(proxyUrl.getHost(), proxyUrl.getPort(), proxyUrl.getProtocol());
        }
        catch (IOException e) {
            throw new ClientException("SDK.InvalidProxy", "proxy url is invalid");
        }
    }

    public static boolean needProxy(String targetHost, String clientNoProxyList, String envNoProxyList) {
        String[] noProxyArr;
        String noProxyList;
        String string = noProxyList = !StringUtils.isEmpty(clientNoProxyList) ? clientNoProxyList : envNoProxyList;
        if (StringUtils.isEmpty(noProxyList)) {
            return true;
        }
        for (String host : noProxyArr = noProxyList.split(",")) {
            if (!host.equals(targetHost)) continue;
            return false;
        }
        return true;
    }

    static {
        Boolean flag;
        log = LogFactory.getLog(HttpUtil.class);
        isHttpDebug = flag = Boolean.valueOf("sdk".equalsIgnoreCase(System.getenv("DEBUG")));
        isHttpContentDebug = flag;
    }
}

