/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.profile;

import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.CredentialsBackupCompatibilityAdaptor;
import com.aliyuncs.auth.ICredentialProvider;
import com.aliyuncs.auth.ISigner;
import com.aliyuncs.endpoint.DefaultEndpointResolver;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.utils.ParameterHelper;
import org.slf4j.Logger;

public class DefaultProfile
implements IClientProfile {
    private static DefaultProfile profile = null;
    private String regionId = null;
    private FormatType acceptFormat = null;
    private ICredentialProvider icredential = null;
    private Credential credential;
    private String certPath;
    private HttpClientConfig httpClientConfig = HttpClientConfig.getDefault();
    private boolean usingInternalLocationService = false;
    private boolean usingVpcEndpoint = false;
    private Logger logger;
    private String logFormat = "{method} {uri} HTTP/{version} {code} {cost} {hostname} {pid} {error}";
    private boolean isCloseTrace = false;
    private String locationServiceEndpoint = null;
    private String locationServiceApiVersion = null;

    private DefaultProfile() {
    }

    private DefaultProfile(String regionId) {
        this.regionId = regionId;
    }

    private DefaultProfile(String regionId, Credential creden) {
        this.credential = creden;
        this.regionId = regionId;
    }

    private DefaultProfile(String region, ICredentialProvider icredential) {
        this.regionId = region;
        this.icredential = icredential;
    }

    public static synchronized DefaultProfile getProfile() {
        if (null == profile) {
            profile = new DefaultProfile();
        }
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, ICredentialProvider icredential) {
        profile = new DefaultProfile(regionId, icredential);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, String accessKeyId, String secret) {
        profile = new DefaultProfile(regionId, new Credential(accessKeyId, secret));
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, String accessKeyId, String secret, String stsToken) {
        Credential creden = new Credential(accessKeyId, secret, stsToken);
        profile = new DefaultProfile(regionId, creden);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId) {
        return new DefaultProfile(regionId);
    }

    @Deprecated
    public static synchronized void addEndpoint(String endpointName, String regionId, String product, String domain) {
        DefaultProfile.addEndpoint(endpointName, regionId, product, domain, true);
    }

    @Deprecated
    public static synchronized void addEndpoint(String endpointName, String regionId, String product, String domain, boolean isNeverExpire) {
        DefaultProfile.addEndpoint(regionId, product, domain);
    }

    public static synchronized void addEndpoint(String regionId, String product, String endpoint) {
        ParameterHelper.validateParameter(regionId, "regionId");
        DefaultEndpointResolver.predefinedEndpointResolver.putEndpointEntry(regionId, product, endpoint);
    }

    @Override
    public synchronized String getRegionId() {
        return this.regionId;
    }

    @Override
    public synchronized FormatType getFormat() {
        return this.acceptFormat;
    }

    @Override
    public synchronized Credential getCredential() {
        if (null == this.credential && null != this.icredential) {
            this.credential = this.icredential.fresh();
        }
        return this.credential;
    }

    @Override
    @Deprecated
    public ISigner getSigner() {
        return null;
    }

    @Override
    public void setCredentialsProvider(AlibabaCloudCredentialsProvider credentialsProvider) {
        if (this.credential != null) {
            return;
        }
        this.credential = new CredentialsBackupCompatibilityAdaptor(credentialsProvider);
    }

    @Override
    public String getCertPath() {
        return this.certPath;
    }

    @Override
    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    @Override
    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @Override
    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    @Override
    public void enableUsingInternalLocationService() {
        this.usingInternalLocationService = true;
    }

    @Override
    public boolean isUsingInternalLocationService() {
        return this.usingInternalLocationService;
    }

    @Override
    public boolean isUsingVpcEndpoint() {
        return this.usingVpcEndpoint;
    }

    @Override
    public void enableUsingVpcEndpoint() {
        this.usingVpcEndpoint = true;
    }

    @Override
    @Deprecated
    public void setUsingInternalLocationService() {
        this.enableUsingInternalLocationService();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getLogFormat() {
        return this.logFormat;
    }

    @Override
    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    @Override
    public boolean isCloseTrace() {
        return this.isCloseTrace;
    }

    @Override
    public void setCloseTrace(boolean closeTrace) {
        this.isCloseTrace = closeTrace;
    }

    @Override
    public String getLocationServiceEndpoint() {
        return this.locationServiceEndpoint;
    }

    @Override
    public void setLocationServiceEndpoint(String locationServiceEndpoint) {
        this.locationServiceEndpoint = locationServiceEndpoint;
    }

    @Override
    public String getLocationServiceApiVersion() {
        return this.locationServiceApiVersion;
    }

    @Override
    public void setLocationServiceApiVersion(String locationServiceApiVersion) {
        this.locationServiceApiVersion = locationServiceApiVersion;
    }
}

