/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry.conditions;

import com.aliyun.core.utils.Validate;
import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.policy.retry.conditions.RetryCondition;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class AndRetryCondition
implements RetryCondition {
    private final Set<RetryCondition> conditions = new LinkedHashSet<RetryCondition>();

    private AndRetryCondition(RetryCondition ... conditions) {
        Collections.addAll(this.conditions, Validate.notEmpty((Object[])conditions, (String)"%s cannot be empty.", (Object[])new Object[]{"conditions"}));
    }

    public static AndRetryCondition create(RetryCondition ... conditions) {
        return new AndRetryCondition(conditions);
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return this.conditions.stream().allMatch(r -> r.shouldRetry(context));
    }

    @Override
    public void requestWillNotBeRetried(RetryPolicyContext context) {
        this.conditions.forEach(c -> c.requestWillNotBeRetried(context));
    }
}

