package darabonba.core;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.http.BodyType;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.EncodeUtil;
import com.aliyun.core.utils.StringUtils;
import darabonba.core.utils.ModelUtil;

import java.io.InputStream;
import java.util.*;

public final class TeaRequest {
    @NameInMap("product")
    private String product;

    @NameInMap("endpointRule")
    private String endpointRule;

    @NameInMap("endpointMap")
    private Map<String, String> endpointMap;

    @NameInMap("resource")
    private List<String> resource;

    @NameInMap("headers")
    private HttpHeaders headers;

    private Set<String> additionalHeaderNames;

    @NameInMap("query")
    private Map<String, String> query;

    @NameInMap("hostMap")
    private Map<String, String> hostMap;

    @NameInMap("body")
    private Object body;

    @NameInMap("stream")
    private InputStream stream;

    @NameInMap("action")
    private String action;

    @NameInMap("version")
    private String version;

    @NameInMap("pathname")
    private String pathname;

    @NameInMap("pathRegex")
    private String pathRegex = "/";

    @NameInMap("bodyType")
    private String bodyType = BodyType.JSON;

    @NameInMap("bodyIsForm")
    private Boolean bodyIsForm = false;

    @NameInMap("reqBodyType")
    private String reqBodyType = BodyType.JSON;

    @NameInMap("style")
    private RequestStyle style = RequestStyle.ANY;

    @NameInMap("configuration")
    private RequestConfiguration requestConfiguration;

    @NameInMap("method")
    private HttpMethod method = HttpMethod.GET;

    private TeaRequest() {
    }

    public static TeaRequest create() {
        return new TeaRequest();
    }

    public String product() {
        return product;
    }

    public TeaRequest setProduct(String product) {
        this.product = product;
        return this;
    }

    public String endpointRule() {
        return endpointRule;
    }

    public TeaRequest setEndpointRule(String endpointRule) {
        this.endpointRule = endpointRule;
        return this;
    }

    public Map<String, String> endpointMap() {
        return endpointMap;
    }

    public TeaRequest setEndpointMap(Map<String, String> endpointMap) {
        this.endpointMap = endpointMap;
        return this;
    }

    public List<String> resource() {
        return resource;
    }

    public TeaRequest setResource(List<String> resource) {
        this.resource = resource;
        return this;
    }

    public HttpHeaders headers() {
        return headers;
    }

    public TeaRequest setHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Set<String> additionalHeaderNames() {
        return additionalHeaderNames;
    }

    public TeaRequest setAdditionalHeaderNames(Set<String> additionalHeaderNames) {
        this.additionalHeaderNames = additionalHeaderNames;
        return this;
    }

    public Map<String, String> query() {
        return query;
    }

    public TeaRequest setQuery(Map<String, String> query) {
        this.query = query;
        return this;
    }

    public Map<String, String> hostMap() {
        return hostMap;
    }

    public TeaRequest setHostMap(Map<String, String> hostMap) {
        this.hostMap = hostMap;
        return this;
    }

    public Object body() {
        return body;
    }

    public TeaRequest setBody(Object body) {
        this.body = body;
        return this;
    }

    public InputStream stream() {
        return stream;
    }

    public TeaRequest setStream(InputStream stream) {
        this.stream = stream;
        return this;
    }

    public String action() {
        return action;
    }

    public TeaRequest setAction(String action) {
        this.action = action;
        return this;
    }

    public String version() {
        return version;
    }

    public TeaRequest setVersion(String version) {
        this.version = version;
        return this;
    }

    public String pathname() {
        return pathname;
    }

    public TeaRequest setPathname(String pathname) {
        this.pathname = pathname;
        return this;
    }

    public String pathRegex() {
        return pathRegex;
    }

    public TeaRequest setPathRegex(String pathRegex) {
        this.pathRegex = pathRegex;
        return this;
    }

    public String bodyType() {
        return bodyType;
    }

    public TeaRequest setBodyType(String bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    public Boolean bodyIsForm() {
        return bodyIsForm;
    }

    public TeaRequest setBodyIsForm(Boolean bodyIsForm) {
        this.bodyIsForm = bodyIsForm;
        return this;
    }

    public String reqBodyType() {
        return reqBodyType;
    }

    public TeaRequest setReqBodyType(String reqBodyType) {
        this.reqBodyType = reqBodyType;
        return this;
    }

    public RequestStyle style() {
        return style;
    }

    public TeaRequest setStyle(RequestStyle style) {
        this.style = style;
        return this;
    }

    public RequestConfiguration requestConfiguration() {
        return requestConfiguration;
    }

    public TeaRequest setRequestConfiguration(RequestConfiguration requestConfiguration) {
        this.requestConfiguration = requestConfiguration;
        return this;
    }

    public HttpMethod method() {
        return method;
    }

    public TeaRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public TeaRequest formModel(RequestModel model) {
        this.query = ModelUtil.queryConvert(model);
        this.stream = ModelUtil.streamConvert(model);
        if (this.stream == null) {
            this.body = ModelUtil.bodyConvert(model, this.bodyIsForm);
        }
        this.headers = new HttpHeaders(ModelUtil.headersConvert(model));
        this.pathname = ModelUtil.pathConvert(model, this.pathRegex());
        this.hostMap = ModelUtil.hostConvert(model);
        this.requestConfiguration = model.getRequestConfiguration();
        return this;
    }

    public TeaRequest copy() {
        return create()
                .setProduct(product)
                .setEndpointRule(endpointRule)
                .setEndpointMap(endpointMap)
                .setVersion(version)
                .setHeaders(headers)
                .setQuery(query)
                .setHostMap(hostMap)
                .setBody(body)
                .setStream(stream)
                .setAction(action)
                .setPathname(pathname)
                .setPathRegex(pathRegex)
                .setBodyType(bodyType)
                .setBodyIsForm(bodyIsForm)
                .setReqBodyType(reqBodyType)
                .setStyle(style)
                .setMethod(method)
                .setRequestConfiguration(requestConfiguration);
    }

    @Override
    public String toString() {
        Map<String, Object> fieldMap = new HashMap<>();
        fieldMap.put("product", product);
        fieldMap.put("action", action);
        fieldMap.put("version", version);
        fieldMap.put("headers", headers);
        fieldMap.put("pathname", pathname);
        fieldMap.put("bodyType", bodyType);
        fieldMap.put("reqBodyType", reqBodyType);
        fieldMap.put("style", style);
        return StringUtils.toAliString("TeaRequest", fieldMap);
    }
}
