package darabonba.core.client;

import com.aliyun.core.http.HttpResponseHandler;
import darabonba.core.*;

public class ClientExecutionParams<InputT extends RequestModel, OutputT extends TeaModel> {
    private InputT input;   // apiRequest
    private OutputT output; // apiResponse
    private TeaRequest request; // the transformation model from input
    private TeaRequestBody requestBody; // the body of request  by app
    private TeaResponseHandler responseHandler; // Callback interface to handle a streaming asynchronous response
    private HttpResponseHandler httpResponseHandler;

    public InputT getInput() {
        return input;
    }

    public ClientExecutionParams<InputT, OutputT> withInput(InputT input) {
        this.input = input;
        return this;
    }

    public OutputT getOutput() {
        return output;
    }

    public ClientExecutionParams<InputT, OutputT> withOutput(OutputT output) {
        this.output = output;
        return this;
    }

    public TeaRequest getRequest() {
        return request;
    }

    public ClientExecutionParams<InputT, OutputT> withRequest(TeaRequest request) {
        this.request = request;
        return this;
    }

    public TeaRequestBody getRequestBody() {
        return requestBody;
    }

    public ClientExecutionParams<InputT, OutputT> withRequestBody(TeaRequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public TeaResponseHandler getResponseHandler() {
        return responseHandler;
    }

    public HttpResponseHandler getHttpResponseHandler() {
        return httpResponseHandler;
    }

    public ClientExecutionParams<InputT, OutputT> withResponseHandler(TeaResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public ClientExecutionParams<InputT, OutputT> withHttpResponseHandler(HttpResponseHandler httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
        return this;
    }
}
