package darabonba.core.interceptor;

import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.http.HttpResponseHandler;
import darabonba.core.*;
import darabonba.core.sync.RequestBody;

public class InterceptorContext<OutputT extends TeaModel> {
    private TeaRequest teaRequest;
    private TeaRequestBody teaRequestBody;
    private HttpRequest httpRequest;
    private HttpResponse httpResponse;
    private TeaResponse teaResponse;
    private TeaResponseHandler teaResponseHandler;
    private HttpResponseHandler httpResponseHandler;
    private String bodyType;
    private TeaConfiguration configuration;
    private OutputT output;

    private InterceptorContext(Builder builder) {
        this.teaRequest = builder.teaRequest;
        this.teaRequestBody = builder.teaRequestBody;
        this.httpRequest = builder.httpRequest;
        this.httpResponse = builder.httpResponse;
        this.teaResponse = builder.teaResponse;
        this.teaResponseHandler = builder.teaResponseHandler;
        this.httpResponseHandler = builder.httpResponseHandler;
        this.bodyType = builder.bodyType;
        this.configuration = builder.configuration;
        this.output = (OutputT) builder.output;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TeaRequest teaRequest() {
        return teaRequest;
    }

    public TeaRequestBody teaRequestBody() {
        return teaRequestBody;
    }

    public HttpRequest httpRequest() {
        return httpRequest;
    }

    public HttpResponse httpResponse() {
        return httpResponse;
    }

    public TeaResponse teaResponse() {
        return teaResponse;
    }

    public TeaResponseHandler teaResponseHandler() {
        return teaResponseHandler;
    }

    public HttpResponseHandler httpResponseHandler() {
        return httpResponseHandler;
    }

    public String bodyType() {
        return bodyType;
    }

    public TeaConfiguration configuration() {
        return configuration;
    }

    public OutputT output() {
        return output;
    }

    public void setTeaRequest(TeaRequest teaRequest) {
        this.teaRequest = teaRequest;
    }

    public void setTeaRequestBody(RequestBody teaRequestBody) {
        this.teaRequestBody = teaRequestBody;
    }

    public void setHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void setTeaResponse(TeaResponse teaResponse) {
        this.teaResponse = teaResponse;
    }

    public void setTeaResponseHandler(TeaResponseHandler teaResponseHandler) {
        this.teaResponseHandler = teaResponseHandler;
    }

    public void setHttpResponseHandler(HttpResponseHandler httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public void setConfiguration(TeaConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setOutput(OutputT output) {
        this.output = output;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private TeaRequest teaRequest;
        private TeaRequestBody teaRequestBody;
        private HttpRequest httpRequest;
        private HttpResponse httpResponse;
        private TeaResponse teaResponse;
        private TeaResponseHandler teaResponseHandler;
        private HttpResponseHandler httpResponseHandler;
        private String bodyType;
        private TeaConfiguration configuration;
        private TeaModel output;

        private Builder() {
        }

        private Builder(InterceptorContext context) {
            this.teaRequest = context.teaRequest;
            this.teaRequestBody = context.teaRequestBody;
            this.httpRequest = context.httpRequest;
            this.httpResponse = context.httpResponse;
            this.teaResponse = context.teaResponse;
            this.teaResponseHandler = context.teaResponseHandler;
            this.httpResponseHandler = context.httpResponseHandler;
            this.bodyType = context.bodyType;
            this.configuration = context.configuration;
            this.output = context.output;
        }

        public Builder teaRequest(TeaRequest teaRequest) {
            this.teaRequest = teaRequest;
            return this;
        }

        public Builder teaRequestBody(TeaRequestBody teaRequestBody) {
            this.teaRequestBody = teaRequestBody;
            return this;
        }

        public Builder httpRequest(HttpRequest httpRequest) {
            this.httpRequest = httpRequest;
            return this;
        }

        public Builder httpResponse(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        public Builder teaResponse(TeaResponse teaResponse) {
            this.teaResponse = teaResponse;
            return this;
        }

        public Builder teaResponseHandler(TeaResponseHandler teaResponseHandler) {
            this.teaResponseHandler = teaResponseHandler;
            return this;
        }

        public Builder httpResponseHandler(HttpResponseHandler httpResponseHandler) {
            this.httpResponseHandler = httpResponseHandler;
            return this;
        }

        public Builder bodyType(String bodyType) {
            this.bodyType = bodyType;
            return this;
        }

        public Builder configuration(TeaConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder output(TeaModel output) {
            this.output = output;
            return this;
        }

        public InterceptorContext build() {
            return new InterceptorContext(this);
        }
    }
}
