/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;

@InterfaceAudience.Private
public class TableAddFamilyHandler
extends TableEventHandler {
    private final HColumnDescriptor familyDesc;

    public TableAddFamilyHandler(TableName tableName, HColumnDescriptor familyDesc, Server server, MasterServices masterServices) {
        super(EventType.C_M_ADD_FAMILY, tableName, server, masterServices);
        this.familyDesc = familyDesc;
    }

    @Override
    protected void prepareWithTableLock() throws IOException {
        super.prepareWithTableLock();
        HTableDescriptor htd = this.getTableDescriptor();
        if (htd.hasFamily(this.familyDesc.getName())) {
            throw new InvalidFamilyOperationException("Family '" + this.familyDesc.getNameAsString() + "' already exists so cannot be added");
        }
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preAddColumnHandler(this.tableName, this.familyDesc);
        }
        this.masterServices.getMasterFileSystem().addColumn(this.tableName, this.familyDesc);
        if (cpHost != null) {
            cpHost.postAddColumnHandler(this.tableName, this.familyDesc);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        String family = "UnknownFamily";
        if (this.familyDesc != null) {
            family = this.familyDesc.getNameAsString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName + "-" + family;
    }
}

