/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NoLimitScannerContext;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NonReversedNonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;

@InterfaceAudience.Private
public class KeyValueHeap
extends NonReversedNonLazyKeyValueScanner
implements KeyValueScanner,
InternalScanner {
    private static final Log LOG = LogFactory.getLog(KeyValueHeap.class);
    protected PriorityQueue<KeyValueScanner> heap = null;
    protected KeyValueScanner current = null;
    protected KVScannerComparator comparator;

    public KeyValueHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
        this(scanners, new KVScannerComparator(comparator));
    }

    KeyValueHeap(List<? extends KeyValueScanner> scanners, KVScannerComparator comparator) throws IOException {
        this.comparator = comparator;
        if (!scanners.isEmpty()) {
            this.heap = new PriorityQueue<KeyValueScanner>(scanners.size(), this.comparator);
            for (KeyValueScanner keyValueScanner : scanners) {
                if (keyValueScanner.peek() != null) {
                    this.heap.add(keyValueScanner);
                    continue;
                }
                keyValueScanner.close();
            }
            this.current = this.pollRealKV();
        }
    }

    @Override
    public Cell peek() {
        if (this.current == null) {
            return null;
        }
        return this.current.peek();
    }

    @Override
    public Cell next() throws IOException {
        if (this.current == null) {
            return null;
        }
        Cell kvReturn = this.current.next();
        Cell kvNext = this.current.peek();
        if (kvNext == null) {
            this.current.close();
            this.current = null;
            this.current = this.pollRealKV();
        } else {
            KeyValueScanner topScanner = this.heap.peek();
            if (topScanner != null && this.comparator.compare(kvNext, topScanner.peek()) >= 0) {
                this.heap.add(this.current);
                this.current = null;
                this.current = this.pollRealKV();
            }
        }
        return kvReturn;
    }

    @Override
    public boolean next(List<Cell> result) throws IOException {
        return this.next(result, NoLimitScannerContext.getInstance());
    }

    @Override
    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        if (this.current == null) {
            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
        }
        InternalScanner currentAsInternal = (InternalScanner)((Object)this.current);
        boolean moreCells = currentAsInternal.next(result, scannerContext);
        Cell pee = this.current.peek();
        if (pee == null || !moreCells) {
            this.current.close();
        } else {
            this.heap.add(this.current);
        }
        this.current = null;
        this.current = this.pollRealKV();
        if (this.current == null) {
            moreCells = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
        }
        return moreCells;
    }

    @Override
    public void close() {
        if (this.current != null) {
            this.current.close();
        }
        if (this.heap != null) {
            KeyValueScanner scanner;
            while ((scanner = this.heap.poll()) != null) {
                scanner.close();
            }
        }
    }

    @Override
    public boolean seek(Cell seekKey) throws IOException {
        return this.generalizedSeek(false, seekKey, false, false);
    }

    @Override
    public boolean reseek(Cell seekKey) throws IOException {
        return this.generalizedSeek(false, seekKey, true, false);
    }

    @Override
    public boolean requestSeek(Cell key, boolean forward, boolean useBloom) throws IOException {
        return this.generalizedSeek(true, key, forward, useBloom);
    }

    private boolean generalizedSeek(boolean isLazy, Cell seekKey, boolean forward, boolean useBloom) throws IOException {
        if (!isLazy && useBloom) {
            throw new IllegalArgumentException("Multi-column Bloom filter optimization requires a lazy seek");
        }
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        KeyValueScanner scanner = null;
        try {
            while ((scanner = this.heap.poll()) != null) {
                Cell topKey = scanner.peek();
                if (this.comparator.getComparator().compare(seekKey, topKey) <= 0) {
                    this.heap.add(scanner);
                    scanner = null;
                    this.current = this.pollRealKV();
                    return this.current != null;
                }
                boolean seekResult = isLazy && this.heap.size() > 0 ? scanner.requestSeek(seekKey, forward, useBloom) : NonLazyKeyValueScanner.doRealSeek(scanner, seekKey, forward);
                if (!seekResult) {
                    scanner.close();
                    continue;
                }
                this.heap.add(scanner);
            }
        }
        catch (Exception e) {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception ce) {
                    LOG.warn((Object)"close KeyValueScanner error", (Throwable)ce);
                }
            }
            throw e;
        }
        return false;
    }

    protected KeyValueScanner pollRealKV() throws IOException {
        KeyValueScanner kvScanner = this.heap.poll();
        if (kvScanner == null) {
            return null;
        }
        while (kvScanner != null && !kvScanner.realSeekDone()) {
            if (kvScanner.peek() != null) {
                try {
                    kvScanner.enforceSeek();
                }
                catch (IOException ioe) {
                    kvScanner.close();
                    throw ioe;
                }
                Cell curKV = kvScanner.peek();
                if (curKV != null) {
                    KeyValueScanner nextEarliestScanner = this.heap.peek();
                    if (nextEarliestScanner == null) {
                        return kvScanner;
                    }
                    Cell nextKV = nextEarliestScanner.peek();
                    if (nextKV == null || this.comparator.compare(curKV, nextKV) < 0) {
                        return kvScanner;
                    }
                    this.heap.add(kvScanner);
                } else {
                    kvScanner.close();
                }
            } else {
                kvScanner.close();
            }
            kvScanner = this.heap.poll();
        }
        return kvScanner;
    }

    public PriorityQueue<KeyValueScanner> getHeap() {
        return this.heap;
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }

    KeyValueScanner getCurrentForTesting() {
        return this.current;
    }

    @Override
    public Cell getNextIndexedKey() {
        return this.current == null ? null : this.current.getNextIndexedKey();
    }

    protected static class KVScannerComparator
    implements Comparator<KeyValueScanner> {
        protected KeyValue.KVComparator kvComparator;

        public KVScannerComparator(KeyValue.KVComparator kvComparator) {
            this.kvComparator = kvComparator;
        }

        @Override
        public int compare(KeyValueScanner left, KeyValueScanner right) {
            long rightSequenceID;
            int comparison = this.compare(left.peek(), right.peek());
            if (comparison != 0) {
                return comparison;
            }
            long leftSequenceID = left.getSequenceID();
            if (leftSequenceID > (rightSequenceID = right.getSequenceID())) {
                return -1;
            }
            if (leftSequenceID < rightSequenceID) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(Cell left, Cell right) {
            return this.kvComparator.compare(left, right);
        }

        public KeyValue.KVComparator getComparator() {
            return this.kvComparator;
        }
    }
}

