/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.TransactionChecker;
import com.aliyun.mns.client.TransactionOperations;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionQueue {
    private static Logger log = LoggerFactory.getLogger(TransactionQueue.class);
    private CloudQueue innerQueue;
    private CloudQueue opLogQueue;
    private TransactionChecker tChecker;
    private boolean isCheckerStop;
    private long checkIntervalInMillisecond;
    private Thread checkerThread;
    private long lifeTime;
    private long delayTime;
    private int transactionTimeoutInSecond;
    public static long DEFAULT_LIFE_TIME_IN_SECONDS = 169200L;
    public static long DEFAULT_DELAY\uff3fTIME_IN_SECONDS = 172800L;

    private Message sendOpLogMessage(String transHandler) {
        Message message = new Message();
        message.setMessageBody(transHandler);
        message.setDelaySeconds(this.transactionTimeoutInSecond);
        message = this.opLogQueue.putMessage(message);
        return message;
    }

    private void confirmOpLogMessage(Message message) {
        try {
            this.opLogQueue.deleteMessage(message.getReceiptHandle());
        }
        catch (Exception e) {
            log.warn("confirmOpLogMessage message:" + message.getReceiptHandle() + " failed.");
        }
    }

    private void mySleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ie) {
            log.error("sleep interrupted error:" + ie.getMessage());
        }
    }

    public TransactionQueue(CloudQueue rawQueue, CloudQueue opLogQueue, TransactionChecker checker, long lifeTimeInSeconds, long delayTimeInSeconds) {
        this.innerQueue = rawQueue;
        this.opLogQueue = opLogQueue;
        this.tChecker = checker;
        this.lifeTime = lifeTimeInSeconds;
        this.delayTime = delayTimeInSeconds;
        this.isCheckerStop = false;
        this.checkIntervalInMillisecond = 5000L;
        this.transactionTimeoutInSecond = 600;
        if (this.tChecker != null) {
            this.checkerThread = new Thread(new CheckTransactionMesssage());
            this.checkerThread.start();
        }
    }

    public void finalize() {
        this.stopCheckThread();
    }

    public Message sendPrepareMessage(Message message) throws ServiceException, ClientException {
        return this.innerQueue.putMessage(message);
    }

    public void commitMessage(String receiptHandle, int retryTimes) throws ServiceException, ClientException {
        int i = 0;
        while (i < retryTimes) {
            ++i;
            try {
                this.innerQueue.changeMessageVisibility(receiptHandle, 1);
                break;
            }
            catch (ServiceException se) {
                if (se.getErrorCode().equals("MessageNotExist")) {
                    break;
                }
            }
            catch (ClientException clientException) {
                // empty catch block
            }
            this.mySleep(1000L);
        }
    }

    public void commitMessage(Message message, int retryTimes) throws ServiceException, ClientException {
        this.commitMessage(message.getReceiptHandle(), retryTimes);
    }

    public void commitMessage(String receiptHandle) throws ServiceException, ClientException {
        this.commitMessage(receiptHandle, 3);
    }

    public void commitMessage(Message message) throws ServiceException, ClientException {
        this.commitMessage(message.getReceiptHandle(), 3);
    }

    public void rollbackMessage(String receiptHandle) throws ServiceException, ClientException {
        block2: {
            try {
                this.innerQueue.deleteMessage(receiptHandle);
            }
            catch (ServiceException se) {
                if (se.getErrorCode().equals("MessageNotExist")) break block2;
                throw se;
            }
        }
    }

    public void rollbackMessage(Message message) throws ServiceException, ClientException {
        this.rollbackMessage(message.getReceiptHandle());
    }

    public Message sendTransMessage(Message message, TransactionOperations operations) throws ServiceException, ClientException {
        String handler = null;
        Message prepareMsg = null;
        Message opLogMessage = null;
        boolean localOpResult = false;
        prepareMsg = this.sendPrepareMessage(message);
        if (prepareMsg == null) {
            return prepareMsg;
        }
        handler = prepareMsg.getReceiptHandle();
        prepareMsg.setMessageBody(message.getMessageBody());
        opLogMessage = this.sendOpLogMessage(handler);
        try {
            localOpResult = operations.doTransaction(prepareMsg);
        }
        catch (Exception e) {
            log.error("exception occurs when do transaction with message:" + prepareMsg.getMessageBody() + ", message handler is:" + prepareMsg.getReceiptHandle());
            localOpResult = false;
        }
        if (localOpResult) {
            this.commitMessage(handler);
        } else {
            this.rollbackMessage(handler);
            prepareMsg = null;
        }
        this.confirmOpLogMessage(opLogMessage);
        return prepareMsg;
    }

    public CloudQueue getInnerQueue() {
        return this.innerQueue;
    }

    public void delete(boolean needDeleteOpLogQueue) {
        this.stopCheckThread();
        this.innerQueue.delete();
        if (needDeleteOpLogQueue) {
            this.opLogQueue.delete();
        }
    }

    public void delete() {
        this.delete(true);
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public CloudQueue getTransOpLogQueue() {
        return this.opLogQueue;
    }

    public void stopCheckThread() {
        this.isCheckerStop = true;
    }

    public long getCheckIntervalInMillsecond() {
        return this.checkIntervalInMillisecond;
    }

    public void setCheckIntervalInMillsecond(long checkIntervalInMillsecond) {
        this.checkIntervalInMillisecond = checkIntervalInMillsecond;
    }

    public int getTransactionTimeoutInSecond() {
        return this.transactionTimeoutInSecond;
    }

    public void setTransactionTimeoutInSecond(int seconds) {
        this.transactionTimeoutInSecond = seconds;
    }

    private class CheckTransactionMesssage
    implements Runnable {
        private CheckTransactionMesssage() {
        }

        @Override
        public void run() {
            log.info("CheckTransactionMesssage thread start");
            while (!TransactionQueue.this.isCheckerStop) {
                block7: {
                    try {
                        Message opLogMessage = TransactionQueue.this.opLogQueue.popMessage();
                        Message transMessage = null;
                        if (opLogMessage == null) break block7;
                        log.info("get an op log for message:" + opLogMessage.getMessageBody());
                        transMessage = new Message();
                        transMessage.setReceiptHandle(opLogMessage.getMessageBody());
                        boolean isTransSuccess = false;
                        try {
                            isTransSuccess = TransactionQueue.this.tChecker.checkTransactionStatus(transMessage);
                        }
                        catch (Exception e) {
                            log.error("exception occurs when doing checkTransactionStatus with:" + opLogMessage.getMessageBody() + "exception message is:" + e.getMessage());
                        }
                        if (isTransSuccess) {
                            TransactionQueue.this.commitMessage(transMessage);
                        } else {
                            TransactionQueue.this.rollbackMessage(transMessage);
                        }
                        TransactionQueue.this.confirmOpLogMessage(opLogMessage);
                    }
                    catch (Exception e) {
                        log.error("exception occurs:" + e.getMessage());
                        e.printStackTrace();
                    }
                }
                TransactionQueue.this.mySleep(TransactionQueue.this.checkIntervalInMillisecond);
            }
            log.info("CheckTransactionMesssage thread end");
        }
    }
}

