/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.auth;

import com.aliyun.mns.common.utils.CodingUtils;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.InstanceProfileCredentials;

public class ServiceCredentials {
    private String accessKeyId;
    private String accessKeySecret;
    private String securityToken;
    private AlibabaCloudCredentialsProvider credentialsProvider;

    public ServiceCredentials() {
    }

    public ServiceCredentials(String accessKeyId, String accessKeySecret, String securityToken) {
        this.setAccessKeyId(accessKeyId);
        this.setAccessKeySecret(accessKeySecret);
        this.setSecurityToken(securityToken);
    }

    public ServiceCredentials(String accessKeyId, String accessKeySecret) {
        this(accessKeyId, accessKeySecret, "");
    }

    public ServiceCredentials(AlibabaCloudCredentialsProvider credentialProvider) {
        this.setCredentialsProvider(credentialProvider);
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        CodingUtils.assertParameterNotNull(accessKeyId, "accessKeyId");
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        CodingUtils.assertParameterNotNull(accessKeySecret, "accessKeySecret");
        this.accessKeySecret = accessKeySecret;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public AlibabaCloudCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(AlibabaCloudCredentialsProvider credentialsProvider) {
        CodingUtils.assertParameterNotNull(credentialsProvider, "credentialsProvider");
        this.credentialsProvider = credentialsProvider;
    }

    public String getAccessKeyIdByProvider() {
        String tmpAccessKeyId;
        if (this.credentialsProvider == null) {
            return null;
        }
        try {
            tmpAccessKeyId = this.credentialsProvider.getCredentials().getAccessKeyId();
        }
        catch (Exception e) {
            tmpAccessKeyId = null;
        }
        return tmpAccessKeyId;
    }

    public String getAccessKeySecretByProvider() {
        String tmpAccesskeySecret;
        if (this.credentialsProvider == null) {
            return null;
        }
        try {
            tmpAccesskeySecret = this.credentialsProvider.getCredentials().getAccessKeySecret();
        }
        catch (Exception e) {
            tmpAccesskeySecret = null;
        }
        return tmpAccesskeySecret;
    }

    public String getSecurityTokenByProvider() {
        String tmpSecurityToken;
        if (this.credentialsProvider == null) {
            return null;
        }
        try {
            AlibabaCloudCredentials credential = this.credentialsProvider.getCredentials();
            tmpSecurityToken = credential instanceof InstanceProfileCredentials ? ((InstanceProfileCredentials)credential).getSessionToken() : null;
        }
        catch (Exception e) {
            tmpSecurityToken = null;
        }
        return tmpSecurityToken;
    }
}

