/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.sample.Queue;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.utils.ServiceSettings;
import com.aliyun.mns.model.PagingListResult;
import java.util.List;

public class ListQueueDemo {
    public static void main(String[] args) {
        CloudAccount account = new CloudAccount(ServiceSettings.getMNSAccessKeyId(), ServiceSettings.getMNSAccessKeySecret(), ServiceSettings.getMNSAccountEndpoint());
        MNSClient client = account.getMNSClient();
        try {
            String marker = null;
            do {
                PagingListResult<Object> list = new PagingListResult();
                try {
                    list = client.listQueueURL("cloud-", marker, 1);
                }
                catch (ClientException ex) {
                    ex.printStackTrace();
                }
                catch (ServiceException ex) {
                    ex.printStackTrace();
                }
                List queues = list.getResult();
                marker = list.getMarker();
                System.out.println("Result:");
                for (String queue : queues) {
                    System.out.println(queue);
                }
            } while (marker != null && marker != "");
        }
        catch (ClientException ce) {
            System.out.println("Something wrong with the network connection between client and MNS service.Please check your network and DNS availablity.");
            ce.printStackTrace();
        }
        catch (ServiceException se) {
            if (se.getErrorCode().equals("QueueNotExist")) {
                System.out.println("Queue is not exist.Please create before use");
            } else if (se.getErrorCode().equals("TimeExpired")) {
                System.out.println("The request is time expired. Please check your local machine timeclock");
            }
            se.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Unknown exception happened!");
            e.printStackTrace();
        }
        client.close();
    }
}

