/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.http;

import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.comm.ExecutionContext;
import com.aliyun.mns.common.comm.RetryStrategy;
import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyun.mns.common.http.HttpCallback;
import com.aliyun.mns.common.http.HttpFactory;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.http.ServiceClient;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;

public class DefaultServiceClient
extends ServiceClient {
    boolean clientIsOpen = false;
    private HttpAsyncClient httpClient;
    private PoolingNHttpClientConnectionManager connManager;
    private Integer refCount = 0;

    DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.connManager = HttpFactory.createConnectionManager(config);
        this.httpClient = HttpFactory.createHttpAsyncClient(this.connManager, config);
        this.ref();
    }

    @Override
    synchronized int ref() {
        this.refCount = this.refCount + 1;
        this.open();
        return this.refCount;
    }

    @Override
    synchronized int unRef() {
        this.refCount = this.refCount - 1;
        if (this.refCount == 0) {
            this.close();
        }
        return this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<HttpResponse> sendRequestCore(ServiceClient.Request request, ExecutionContext context, HttpCallback<T> callback) throws IOException {
        assert (request != null && context != null);
        HttpRequestBase httpRequest = HttpFactory.createHttpRequest(request, context);
        Future future = null;
        try {
            future = this.httpClient.execute((HttpUriRequest)httpRequest, callback);
        }
        catch (IllegalStateException e) {
            if (!((CloseableHttpAsyncClient)this.httpClient).isRunning()) {
                DefaultServiceClient defaultServiceClient = this;
                synchronized (defaultServiceClient) {
                    if (!((CloseableHttpAsyncClient)this.httpClient).isRunning()) {
                        this.close();
                        this.connManager = HttpFactory.createConnectionManager(this.config);
                        this.httpClient = HttpFactory.createHttpAsyncClient(this.connManager, this.config);
                        this.open();
                    }
                }
            }
            future = this.httpClient.execute((HttpUriRequest)httpRequest, callback);
        }
        return future;
    }

    private void open() {
        if (this.httpClient != null && this.httpClient instanceof CloseableHttpAsyncClient && !this.clientIsOpen) {
            ((CloseableHttpAsyncClient)this.httpClient).start();
            this.clientIsOpen = true;
            HttpFactory.IdleConnectionMonitor.getInstance().addConnMgr((NHttpClientConnectionManager)this.connManager);
        }
    }

    @Override
    public boolean isOpen() {
        return this.clientIsOpen;
    }

    @Override
    protected void close() {
        HttpFactory.IdleConnectionMonitor.getInstance().removeConnMgr((NHttpClientConnectionManager)this.connManager);
        if (this.httpClient != null && this.httpClient instanceof CloseableHttpAsyncClient) {
            try {
                ((CloseableHttpAsyncClient)this.httpClient).close();
                this.clientIsOpen = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            String errorCode;
            if (ex instanceof ClientException && ((errorCode = ((ClientException)ex).getErrorCode()).equals("ConnectionTimeout") || errorCode.equals("SocketTimeout"))) {
                return true;
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

