/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.http;

import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.parser.JAXBResultParser;
import com.aliyun.mns.common.parser.ResultParseException;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.common.utils.IOUtils;
import com.aliyun.mns.model.ErrorMessage;
import java.io.IOException;

public class ExceptionResultParser
implements ResultParser<Exception> {
    private String userRequestId;

    public ExceptionResultParser(String userRequestId) {
        this.userRequestId = userRequestId;
    }

    @Override
    public Exception parse(ResponseMessage response) throws ResultParseException {
        assert (response != null);
        if (response.isSuccessful()) {
            return null;
        }
        RuntimeException result = null;
        String content = null;
        try {
            content = IOUtils.readStreamAsString(response.getContent(), "UTF-8");
        }
        catch (IOException e) {
            return new ServiceException(e.getMessage(), this.userRequestId, e);
        }
        try {
            JAXBResultParser d = new JAXBResultParser(ErrorMessage.class);
            Object obj = d.parse(content);
            if (obj instanceof ErrorMessage) {
                ErrorMessage err = (ErrorMessage)obj;
                result = new ServiceException(err.Message, null, err.Code, err.RequestId, err.HostId);
            }
        }
        catch (Exception e) {
            String message = e.getMessage() + "\n" + content;
            result = new ClientException(message, null, e.getCause());
        }
        return result;
    }
}

