/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.utils;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtil {
    private static final Logger logger = LoggerFactory.getLogger(ThreadUtil.class);
    private static final ThreadPoolExecutor DEFAULT_THREAD_POOL_EXECUTOR = ThreadUtil.initThreadPoolExecutorAbort();

    public static ScheduledExecutorService initScheduledExecutorService(final String name, final boolean isDaemon, Integer poolSize) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(name);
                t.setDaemon(isDaemon);
                return t;
            }
        };
        if (poolSize == null || poolSize == 0) {
            poolSize = Runtime.getRuntime().availableProcessors() * 2;
        }
        return new ScheduledThreadPoolExecutor((int)poolSize, threadFactory);
    }

    public static ThreadPoolExecutor initThreadPoolExecutorAbort() {
        int threadCt = Runtime.getRuntime().availableProcessors() * 2;
        int corePoolSize = Math.min(threadCt, 4);
        int coreMaxPoolSize = 50;
        return ThreadUtil.initThreadPoolExecutorAbort(corePoolSize, coreMaxPoolSize);
    }

    public static ThreadPoolExecutor initThreadPoolExecutorAbort(int corePoolSize, int coreMaxPoolSize) {
        long keepActiveTime = 1000L;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(2000);
        ThreadFactory namedThreadFactory = Executors.defaultThreadFactory();
        ThreadPoolExecutor.AbortPolicy abortPolicy = new ThreadPoolExecutor.AbortPolicy();
        return new ThreadPoolExecutor(corePoolSize, coreMaxPoolSize, keepActiveTime, timeUnit, workQueue, namedThreadFactory, abortPolicy);
    }

    public static void sleep(Long millionSeconds) {
        try {
            Thread.sleep(millionSeconds);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void asyncWithoutReturn(ThreadPoolExecutor threadPoolExecutor, final AsyncRunInterface asyncRunInterface) {
        threadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                asyncRunInterface.run();
            }
        });
    }

    public static void asyncWithReturn(ThreadPoolExecutor threadPoolExecutor, Integer maxThreadNum, final AsyncRunInterface asyncRunInterface) {
        if (maxThreadNum == null || maxThreadNum < 1) {
            maxThreadNum = 50;
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < maxThreadNum; ++i) {
            Future future = threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    asyncRunInterface.run();
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface AsyncRunInterface {
        public void run();
    }
}

