/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model;

import com.aliyun.mns.model.BaseMessage;
import com.aliyun.mns.model.ErrorMessageResult;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public final class Message
extends BaseMessage {
    private String receiptHandle;
    private Integer priority;
    private Date enqueueTime;
    private Date nextVisibleTime;
    private Date firstDequeueTime;
    private Integer dequeueCount;
    private Integer delaySeconds;
    private ErrorMessageResult errorMessage;

    public Message() {
    }

    public Message(String messageBody) {
        this.setMessageBody(messageBody);
    }

    public Message(byte[] messageBody) {
        this.setMessageBody(messageBody);
    }

    public Integer getDelaySeconds() {
        return this.delaySeconds;
    }

    public void setDelaySeconds(int delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public void setReceiptHandle(String receiptHandle) {
        this.receiptHandle = receiptHandle;
    }

    public Date getEnqueueTime() {
        return this.enqueueTime;
    }

    public void setEnqueueTime(Date enqueueTime) {
        this.enqueueTime = enqueueTime;
    }

    public Date getNextVisibleTime() {
        return this.nextVisibleTime;
    }

    public void setNextVisibleTime(Date nextVisibleTime) {
        this.nextVisibleTime = nextVisibleTime;
    }

    public Date getFirstDequeueTime() {
        return this.firstDequeueTime;
    }

    public void setFirstDequeueTime(Date firstDequeueTime) {
        this.firstDequeueTime = firstDequeueTime;
    }

    public Integer getDequeueCount() {
        return this.dequeueCount;
    }

    public void setDequeueCount(int dequeueCount) {
        this.dequeueCount = dequeueCount;
    }

    @Override
    public void setMessageBody(byte[] messageBody) {
        this.setMessageBody(messageBody, MessageBodyType.BASE64);
    }

    public void setMessageBodyAsRawString(byte[] messageBody) {
        this.setMessageBody(messageBody, MessageBodyType.RAW_STRING);
    }

    public void setMessageBody(byte[] messageBody, MessageBodyType bodyType) {
        if (bodyType == MessageBodyType.BASE64) {
            byte[] encodeBase64 = Base64.encodeBase64((byte[])messageBody);
            this.setBaseMessageBody(encodeBase64);
        } else {
            this.setBaseMessageBody(messageBody);
        }
    }

    @Override
    public void setMessageBody(String messageBody) {
        this.setMessageBody(messageBody, MessageBodyType.BASE64);
    }

    public void setMessageBodyAsRawString(String messageBody) {
        this.setMessageBody(messageBody, MessageBodyType.RAW_STRING);
    }

    public void setMessageBody(String messageBody, MessageBodyType bodyType) {
        byte[] bytes;
        try {
            bytes = messageBody.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: UTF-8");
        }
        this.setMessageBody(bytes, bodyType);
    }

    @Override
    public String getMessageBody() {
        return this.getMessageBodyAsString();
    }

    @Deprecated
    public String getMessageBodyAsBase64() {
        if (this.getMessageBodyBytes() == null) {
            return null;
        }
        return new String(this.getMessageBodyBytes());
    }

    public String getMessageBodyAsString() {
        return this.getMessageBodyAsString("UTF-8");
    }

    public String getMessageBodyAsString(String charSet) {
        byte[] messageBodyAsBytes = this.getMessageBodyBytes();
        if (messageBodyAsBytes == null) {
            return null;
        }
        try {
            return new String(Base64.decodeBase64((byte[])messageBodyAsBytes), charSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: " + charSet);
        }
    }

    public String getMessageBodyAsRawString() {
        byte[] messageBodyAsBytes = this.getMessageBodyBytes();
        if (messageBodyAsBytes == null) {
            return null;
        }
        try {
            return new String(messageBodyAsBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: UTF-8");
        }
    }

    public byte[] getMessageBodyAsBytes() {
        byte[] messageBodyAsBytes = this.getMessageBodyBytes();
        return Base64.decodeBase64((byte[])messageBodyAsBytes);
    }

    public byte[] getMessageBodyAsRawBytes() {
        return this.getMessageBodyBytes();
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ErrorMessageResult getErrorMessageDetail() {
        return this.errorMessage;
    }

    public boolean isErrorMessage() {
        return this.errorMessage != null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.getMessageBodyAsString() != null) {
            sb.append("MessageBody:\"");
            sb.append(this.getMessageBodyAsString());
            sb.append("\"");
            sb.append(",");
        }
        if (this.receiptHandle != null) {
            sb.append("ReceiptHandle:\"");
            sb.append(this.receiptHandle);
            sb.append("\"");
            sb.append(",");
        }
        sb.append("DequeueCount:\"");
        sb.append(this.dequeueCount);
        sb.append("\"");
        sb.append(",");
        if (this.enqueueTime != null) {
            sb.append("EnqueueTime:\"");
            sb.append(this.enqueueTime);
            sb.append("\"");
            sb.append(",");
        }
        if (this.firstDequeueTime != null) {
            sb.append("FirstDequeueTime:\"");
            sb.append(this.firstDequeueTime);
            sb.append("\"");
            sb.append(",");
        }
        if (this.nextVisibleTime != null) {
            sb.append("NextVisibleTime:\"");
            sb.append(this.nextVisibleTime);
            sb.append("\"");
            sb.append(",");
        }
        sb.append("Priority:\"");
        sb.append(this.priority);
        sb.append("\"");
        return sb.toString();
    }

    public ErrorMessageResult getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(ErrorMessageResult errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static enum MessageBodyType {
        BASE64,
        RAW_STRING;

    }
}

