/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model;

import com.aliyun.mns.model.AbstractMessagePropertyValue;
import com.aliyun.mns.model.PropertyType;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class MessagePropertyValue
implements AbstractMessagePropertyValue {
    private PropertyType dataType;
    private String stringValue;
    private byte[] binaryValue;

    public MessagePropertyValue(PropertyType type, String value) {
        if (type == null || value == null) {
            throw new IllegalArgumentException("type and value can not be null");
        }
        this.dataType = type;
        switch (type) {
            case NUMBER: {
                try {
                    Double.parseDouble(value);
                    this.stringValue = value;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid number format: " + value);
                }
            }
            case STRING: {
                this.stringValue = value;
                break;
            }
            case BOOLEAN: {
                if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Invalid boolean value: " + value);
                }
                this.stringValue = value;
                break;
            }
            case BINARY: {
                try {
                    this.binaryValue = value.getBytes("UTF-8");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Not support encoding: UTF-8");
                }
            }
            default: {
                throw new IllegalArgumentException("Invalid property type: " + (Object)((Object)type));
            }
        }
    }

    public MessagePropertyValue(byte[] value) {
        this.dataType = PropertyType.BINARY;
        this.binaryValue = value;
    }

    public MessagePropertyValue(int value) {
        this.dataType = PropertyType.NUMBER;
        this.stringValue = String.valueOf(value);
    }

    public MessagePropertyValue(long value) {
        this.dataType = PropertyType.NUMBER;
        this.stringValue = String.valueOf(value);
    }

    public MessagePropertyValue(double value) {
        this.dataType = PropertyType.NUMBER;
        this.stringValue = String.valueOf(value);
    }

    public MessagePropertyValue(String value) {
        this.dataType = PropertyType.STRING;
        this.stringValue = value;
    }

    public MessagePropertyValue(boolean value) {
        this.dataType = PropertyType.BOOLEAN;
        this.stringValue = String.valueOf(value);
    }

    public PropertyType getDataType() {
        return this.dataType;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    @Override
    public String getStringValueByType() {
        try {
            switch (this.dataType) {
                case NUMBER: 
                case STRING: 
                case BOOLEAN: {
                    return this.stringValue;
                }
                case BINARY: {
                    return new String(this.binaryValue, "UTF-8");
                }
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: UTF-8");
        }
    }

    @Override
    public String getDataTypeString() {
        return this.dataType.name();
    }

    public String toString() {
        return "MessagePropertyValue{dataType=" + (Object)((Object)this.dataType) + ", stringValue='" + this.stringValue + '\'' + ", binaryValue=" + Arrays.toString(this.binaryValue) + '}';
    }
}

