/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize.queue;

import com.aliyun.mns.common.BatchDeleteException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.ErrorMessageResult;
import com.aliyun.mns.model.serialize.XMLDeserializer;
import java.io.InputStream;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ErrorReceiptHandleListDeserializer
extends XMLDeserializer<Exception> {
    @Override
    public Exception deserialize(InputStream stream) throws Exception {
        Document doc = this.getDocumentBuilder().parse(stream);
        ServiceException ret = null;
        Element root = doc.getDocumentElement();
        if (root != null) {
            String rootName = root.getNodeName();
            if (rootName == "Errors") {
                NodeList list = doc.getElementsByTagName("Error");
                if (list != null && list.getLength() > 0) {
                    HashMap<String, ErrorMessageResult> results = new HashMap<String, ErrorMessageResult>();
                    for (int i = 0; i < list.getLength(); ++i) {
                        String receiptHandle = this.parseReceiptHandle((Element)list.item(i));
                        ErrorMessageResult result = this.parseErrorResult((Element)list.item(i));
                        results.put(receiptHandle, result);
                    }
                    ret = new BatchDeleteException(results);
                }
            } else if (rootName == "Error") {
                String code = this.safeGetElementContent(root, "Code", "");
                String message = this.safeGetElementContent(root, "Message", "");
                String requestId = this.safeGetElementContent(root, "RequestId", "");
                String hostId = this.safeGetElementContent(root, "HostId", "");
                ret = new ServiceException(message, null, code, requestId, hostId);
            }
        }
        return ret;
    }

    private String parseReceiptHandle(Element root) {
        return this.safeGetElementContent(root, "ReceiptHandle", null);
    }

    private ErrorMessageResult parseErrorResult(Element root) {
        ErrorMessageResult result = new ErrorMessageResult();
        String errorCode = this.safeGetElementContent(root, "ErrorCode", null);
        result.setErrorCode(errorCode);
        String errorMessage = this.safeGetElementContent(root, "ErrorMessage", null);
        result.setErrorMessage(errorMessage);
        return result;
    }
}

