/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk;

import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.client.AlibabaClientFactory;
import com.alibaba.ocean.rawsdk.client.Request;
import com.alibaba.ocean.rawsdk.client.SDKListener;
import com.alibaba.ocean.rawsdk.client.SyncAPIClient;
import com.alibaba.ocean.rawsdk.client.entity.AuthorizationToken;
import com.alibaba.ocean.rawsdk.client.entity.AuthorizationTokenStore;
import com.alibaba.ocean.rawsdk.client.entity.DefaultAuthorizationTokenStore;
import com.alibaba.ocean.rawsdk.client.exception.OceanException;
import com.alibaba.ocean.rawsdk.client.http.mapi.MapiResult;
import com.alibaba.ocean.rawsdk.client.http.mapi.SyncMapiClient;
import com.alibaba.ocean.rawsdk.client.policy.ClientPolicy;
import com.alibaba.ocean.rawsdk.client.policy.RequestPolicy;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.serialize.SerializerListener;
import com.alibaba.ocean.rawsdk.common.AbstractAPIRequest;
import com.alibaba.ocean.rawsdk.common.SDKResult;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ApiExecutor
implements SDKListener {
    private String serverHost = "gw.open.1688.com";
    private int httpPort = 80;
    private int httpsPort = 443;
    private String appKey;
    private String secKey;
    private AuthorizationTokenStore authorizationTokenStore;
    private Map<Class<? extends SerializerListener>, SerializerListener> serializerListeners = new LinkedHashMap<Class<? extends SerializerListener>, SerializerListener>();
    private Map<Class<? extends DeSerializerListener>, DeSerializerListener> deSerializerListeners = new LinkedHashMap<Class<? extends DeSerializerListener>, DeSerializerListener>();
    private volatile SyncAPIClient syncAPIClient;
    private volatile SyncMapiClient syncMAPIClient;

    public ApiExecutor(String appKey, String secKey) {
        this.appKey = appKey;
        this.secKey = secKey;
    }

    public ApiExecutor(String serverHost, int httpPort, int httpsPort, String appKey, String secKey) {
        this.serverHost = serverHost;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.appKey = appKey;
        this.secKey = secKey;
    }

    @Override
    public void register(SerializerListener serializerListener) {
        this.serializerListeners.put(serializerListener.getClass(), serializerListener);
    }

    @Override
    public void register(DeSerializerListener deSerializerListener) {
        this.deSerializerListeners.put(deSerializerListener.getClass(), deSerializerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncAPIClient getAPIClient() {
        ClientPolicy clientPolicy = new ClientPolicy(this.serverHost);
        clientPolicy.setHttpPort(this.httpPort);
        clientPolicy.setHttpsPort(this.httpsPort);
        if (this.appKey != null) {
            clientPolicy.setAppKey(this.appKey);
        }
        if (this.secKey != null) {
            clientPolicy.setSigningKey(this.secKey);
        }
        if (this.authorizationTokenStore == null) {
            this.authorizationTokenStore = new DefaultAuthorizationTokenStore();
        }
        if (this.syncAPIClient == null) {
            ApiExecutor apiExecutor = this;
            synchronized (apiExecutor) {
                if (this.syncAPIClient == null) {
                    this.syncAPIClient = new AlibabaClientFactory().createAPIClient(clientPolicy, this.authorizationTokenStore);
                }
            }
        }
        return this.syncAPIClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncMapiClient getMAPIClient() {
        ClientPolicy clientPolicy = new ClientPolicy(this.serverHost);
        clientPolicy.setHttpPort(this.httpPort);
        clientPolicy.setHttpsPort(this.httpsPort);
        if (this.appKey != null) {
            clientPolicy.setAppKey(this.appKey);
        }
        if (this.secKey != null) {
            clientPolicy.setSigningKey(this.secKey);
        }
        if (this.authorizationTokenStore == null) {
            this.authorizationTokenStore = new DefaultAuthorizationTokenStore();
        }
        if (this.syncMAPIClient == null) {
            ApiExecutor apiExecutor = this;
            synchronized (apiExecutor) {
                if (this.syncMAPIClient == null) {
                    this.syncMAPIClient = new AlibabaClientFactory().createMAPIClient(clientPolicy, this.authorizationTokenStore);
                }
            }
        }
        return this.syncMAPIClient;
    }

    public final AuthorizationToken getToken(String code) {
        try {
            return this.getAPIClient().getToken(code);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final AuthorizationToken refreshToken(String refreshToken) {
        try {
            return this.getAPIClient().refreshToken(refreshToken);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final <TResponse> SDKResult<TResponse> execute(AbstractAPIRequest<TResponse> apiRequest) {
        RequestPolicy reqPolicy = apiRequest.getOceanRequestPolicy();
        try {
            APIId apiId = apiRequest.getOceanApiId();
            Request req = new Request(apiId.getNamespace(), apiId.getName(), apiId.getVersion());
            req.setRequestEntity(apiRequest);
            TResponse ret = this.getAPIClient().send(req, apiRequest.getResponseClass(), reqPolicy, this.serializerListeners.values(), this.deSerializerListeners.values());
            return new SDKResult<TResponse>(ret);
        }
        catch (OceanException e) {
            return new SDKResult(e.getErrorCode(), e.getErrorMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final <TResponse> SDKResult<TResponse> execute(AbstractAPIRequest<TResponse> apiRequest, String accessToken) {
        RequestPolicy reqPolicy = apiRequest.getOceanRequestPolicy();
        try {
            APIId apiId = apiRequest.getOceanApiId();
            Request req = new Request(apiId.getNamespace(), apiId.getName(), apiId.getVersion());
            req.setRequestEntity(apiRequest);
            req.setAccessToken(accessToken);
            TResponse ret = this.getAPIClient().send(req, apiRequest.getResponseClass(), reqPolicy, this.serializerListeners.values(), this.deSerializerListeners.values());
            return new SDKResult<TResponse>(ret);
        }
        catch (OceanException e) {
            return new SDKResult(e.getErrorCode(), e.getErrorMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final <TResponse> SDKResult<MapiResult<TResponse>> mapiExecute(AbstractAPIRequest<TResponse> apiRequest, String accessToken) {
        RequestPolicy reqPolicy = apiRequest.getOceanRequestPolicy();
        try {
            APIId apiId = apiRequest.getOceanApiId();
            Request req = new Request(apiId.getNamespace(), apiId.getName(), apiId.getVersion());
            req.setRequestEntity(apiRequest);
            if (accessToken != null) {
                req.setAccessToken(accessToken);
            }
            MapiResult<TResponse> ret = this.getMAPIClient().mapiSend(req, apiRequest.getResponseClass(), reqPolicy, this.serializerListeners.values(), this.deSerializerListeners.values());
            return new SDKResult<MapiResult<TResponse>>(ret);
        }
        catch (OceanException e) {
            return new SDKResult<MapiResult<TResponse>>(e.getErrorCode(), e.getErrorMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

