/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.client.http.platform;

import com.alibaba.ocean.rawsdk.client.Response;
import com.alibaba.ocean.rawsdk.client.http.AbstractHttpClient;
import com.alibaba.ocean.rawsdk.client.http.HttpResponseBuilder;
import com.alibaba.ocean.rawsdk.client.http.HttpSupport;
import com.alibaba.ocean.rawsdk.client.http.InvokeContext;
import com.alibaba.ocean.rawsdk.client.policy.ClientPolicy;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.serialize.SerializerProvider;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Map;

public class HttpURLConnectionClient
extends AbstractHttpClient {
    public HttpURLConnectionClient(SerializerProvider serializerProvider, HttpResponseBuilder responseBuilder) {
        super(serializerProvider, responseBuilder);
    }

    @Override
    protected Response doMultipartPost(URL url, Map<String, Object> parameters, InvokeContext invokeContext, ClientPolicy clientPolicy, Collection<DeSerializerListener> deSerializerListners) throws IOException {
        HttpURLConnection conn = null;
        Response response = null;
        String BOUNDARY = "---------------------------123821742118716";
        OutputStream out = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            Map<String, String> clientHttpHeader = HttpSupport.buildHttpHeader(invokeContext, clientPolicy);
            for (Map.Entry<String, String> entry : clientHttpHeader.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            out = new DataOutputStream(conn.getOutputStream());
            StringBuffer strBuf = new StringBuffer();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                String inputName = entry.getKey();
                Object inputValue = entry.getValue();
                if (inputValue == null) continue;
                if (inputValue.getClass().isAssignableFrom(byte[].class) || inputValue.getClass().isAssignableFrom(Byte[].class)) {
                    Object[] inputBytes;
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\"\r\n");
                    strBuf.append("Content-Type:application/x-www-form-urlencoded\r\n\r\n");
                    out.write(strBuf.toString().getBytes());
                    if (inputValue instanceof byte[]) {
                        inputBytes = (byte[])inputValue;
                        out.write((byte[])inputBytes);
                    }
                    if (!(inputValue instanceof Byte[])) continue;
                    for (byte b : inputBytes = (Object[])((Byte[])inputValue)) {
                        out.write(b.byteValue());
                    }
                    continue;
                }
                strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                strBuf.append(inputValue);
                out.write(strBuf.toString().getBytes());
            }
            int httpCode = conn.getResponseCode();
            String contentEncoding = conn.getContentEncoding();
            String contentType = conn.getContentType();
            InputStream inputStream = null;
            inputStream = httpCode >= 200 && httpCode <= 299 ? conn.getInputStream() : conn.getErrorStream();
            response = this.getResponseBuilder().buildResponse(inputStream, httpCode, contentEncoding, contentType, invokeContext, deSerializerListners);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response doPost(URL url, Map<String, Object> parameters, InvokeContext invokeContext, ClientPolicy clientPolicy, Collection<DeSerializerListener> deSerializerListners) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        Response response = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            Map<String, String> clientHttpHeader = HttpSupport.buildHttpHeader(invokeContext, clientPolicy);
            for (Map.Entry<String, String> entry : clientHttpHeader.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            String query = HttpSupport.buildQuery(parameters);
            byte[] content = new byte[]{};
            if (query != null) {
                content = query.getBytes(invokeContext.getPolicy().getContentCharset());
            }
            out = conn.getOutputStream();
            out.write(content);
            int httpCode = conn.getResponseCode();
            String contentEncoding = conn.getContentEncoding();
            String contentType = conn.getContentType();
            InputStream inputStream = null;
            inputStream = httpCode >= 200 && httpCode <= 299 ? conn.getInputStream() : conn.getErrorStream();
            response = this.getResponseBuilder().buildResponse(inputStream, httpCode, contentEncoding, contentType, invokeContext, deSerializerListners);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response doGet(URL url, Map<String, Object> parameters, InvokeContext invokeContext, ClientPolicy clientPolicy, Collection<DeSerializerListener> deSerializerListners) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        Response response = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            Map<String, String> clientHttpHeader = HttpSupport.buildHttpHeader(invokeContext, clientPolicy);
            for (Map.Entry<String, String> entry : clientHttpHeader.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            int httpCode = conn.getResponseCode();
            String contentEncoding = conn.getContentEncoding();
            String contentType = conn.getContentType();
            InputStream inputStream = null;
            inputStream = httpCode >= 200 && httpCode <= 299 ? conn.getInputStream() : conn.getErrorStream();
            response = this.getResponseBuilder().buildResponse(inputStream, httpCode, contentEncoding, contentType, invokeContext, deSerializerListners);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }
}

