/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.client.imp.serialize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.ocean.rawsdk.client.entity.ResponseWrapper;
import com.alibaba.ocean.rawsdk.client.imp.serialize.AbstractJsonDeserializer;
import com.alibaba.ocean.rawsdk.client.imp.serialize.OpenPlatformDateCodec;
import com.alibaba.ocean.rawsdk.client.policy.Protocol;
import com.alibaba.ocean.rawsdk.client.serialize.DeSerializerListener;
import com.alibaba.ocean.rawsdk.client.util.ExceptionParser;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class Json2Deserializer
extends AbstractJsonDeserializer {
    private Map<Class<? extends DeSerializerListener>, DeSerializerListener> listnerList = new LinkedHashMap<Class<? extends DeSerializerListener>, DeSerializerListener>();

    @Override
    public String supportedContentType() {
        return Protocol.json2.name();
    }

    @Override
    public <T> ResponseWrapper<T> deSerialize(String content, Class<T> resultType) {
        for (DeSerializerListener deSerializerListener : this.listnerList.values()) {
            deSerializerListener.onResponseDeSerialized(content);
        }
        ParserConfig config = ParserConfig.getGlobalInstance();
        config.putDeserializer(Date.class, (ObjectDeserializer)OpenPlatformDateCodec.instance);
        Object result = JSON.parseObject((String)content, resultType, (ParserConfig)config, null, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
        ResponseWrapper<Object> responseWrapper = new ResponseWrapper<Object>();
        responseWrapper.setResult(result);
        return responseWrapper;
    }

    @Override
    public Throwable buildException(String content, int statusCode) {
        for (DeSerializerListener deSerializerListener : this.listnerList.values()) {
            deSerializerListener.onResponseExceptioned(content);
        }
        Map result = (Map)JSON.parseObject((String)content, Map.class);
        return ExceptionParser.buildException4Json2(result);
    }

    @Override
    public void registeDeSerializerListener(DeSerializerListener listner) {
        if (!this.listnerList.containsKey(listner.getClass())) {
            this.listnerList.put(listner.getClass(), listner);
        }
    }
}

