/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.example;

import com.alibaba.ocean.rawsdk.ApiExecutor;
import com.alibaba.ocean.rawsdk.client.APIId;
import com.alibaba.ocean.rawsdk.client.policy.RequestPolicy;
import com.alibaba.ocean.rawsdk.common.SDKResult;
import com.alibaba.ocean.rawsdk.example.RawSdkExampleData;
import com.alibaba.ocean.rawsdk.example.param.ExampleFamilyGetParam;
import com.alibaba.ocean.rawsdk.example.param.ExampleFamilyGetResult;
import com.alibaba.ocean.rawsdk.example.param.ExampleFamilyPostParam;
import com.alibaba.ocean.rawsdk.example.param.ExampleFamilyPostResult;

public class RawSdkExample {
    public void exampleFamilyGet(ApiExecutor apiExecutor) {
        ExampleFamilyGetParam exampleFamilyGetParam = new ExampleFamilyGetParam();
        APIId oceanApiId = new APIId("api.example", "example.family.get", 1);
        exampleFamilyGetParam.setOceanApiId(oceanApiId);
        RequestPolicy oceanRequestPolicy = new RequestPolicy();
        oceanRequestPolicy.setHttpMethod(RequestPolicy.HttpMethodPolicy.POST).setNeedAuthorization(false).setRequestSendTimestamp(false).setUseHttps(false).setUseSignture(true).setAccessPrivateApi(false);
        exampleFamilyGetParam.setOceanRequestPolicy(oceanRequestPolicy);
        exampleFamilyGetParam.setFamilyNumber(1);
        SDKResult<ExampleFamilyGetResult> exampleFamilyGetResult = apiExecutor.execute(exampleFamilyGetParam);
        System.out.println("ExampleFamilyGet call, family information of Result:" + exampleFamilyGetResult.getResult());
    }

    public void exampleFamilyPost(ApiExecutor apiExecutor, String accessToken) {
        ExampleFamilyPostParam exampleFamilyPostParam = new ExampleFamilyPostParam();
        APIId oceanApiId = new APIId("api.example", "example.family.post", 1);
        exampleFamilyPostParam.setOceanApiId(oceanApiId);
        RequestPolicy oceanRequestPolicy = new RequestPolicy();
        oceanRequestPolicy.setHttpMethod(RequestPolicy.HttpMethodPolicy.POST).setNeedAuthorization(false).setRequestSendTimestamp(false).setUseHttps(false).setUseSignture(true).setAccessPrivateApi(false).setDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        exampleFamilyPostParam.setOceanRequestPolicy(oceanRequestPolicy);
        exampleFamilyPostParam.setComments("Example for SDK");
        exampleFamilyPostParam.setFamily(RawSdkExampleData.createFirstFamily());
        exampleFamilyPostParam.setHouseImg(RawSdkExampleData.getPicture("example.png"));
        SDKResult<ExampleFamilyPostResult> exampleFamilyPostResult = apiExecutor.execute(exampleFamilyPostParam, accessToken);
        System.out.println("ExampleFamilyPost call, Family information of Result:" + exampleFamilyPostResult.getResult().getResult());
        System.out.println("ExampleFamilyPost call, Desc of Result:" + exampleFamilyPostResult.getResult().getResultDesc());
    }

    public static void main(String[] args) {
        ApiExecutor apiExecutor = new ApiExecutor("{appKey}", "{appSecret}");
        RawSdkExample rawSdkExample = new RawSdkExample();
        rawSdkExample.exampleFamilyGet(apiExecutor);
        rawSdkExample.exampleFamilyPost(apiExecutor, "{the access token}");
    }
}

