/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ocean.rawsdk.util;

import com.alibaba.ocean.rawsdk.util.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class SignatureUtil {
    public static final String HMAC_SHA1 = "HmacSHA1";
    public static final String CHARSET_NAME_UTF8 = "UTF-8";
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    public static final char[] digital = "0123456789ABCDEF".toCharArray();

    private static SecretKeySpec buildKey(byte[] key) {
        return new SecretKeySpec(key, HMAC_SHA1);
    }

    public static String encodeHexStr(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            str.append(digital[(bytes[i] & 0xF0) >> 4]);
            str.append(digital[bytes[i] & 0xF]);
        }
        return str.toString();
    }

    public static byte[] hmacSha1(String path, Map<String, Object> parameters, String signingKey) {
        Mac mac;
        try {
            mac = Mac.getInstance(HMAC_SHA1);
            mac.init(SignatureUtil.buildKey(SignatureUtil.toBytes(signingKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        mac.update(path.getBytes(CHARSET_UTF8));
        ArrayList<String> parameterToSort = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            parameterToSort.add(entry.getKey() + entry.getValue());
        }
        Collections.sort(parameterToSort);
        for (String paramToSign : parameterToSort) {
            mac.update(paramToSign.getBytes(CHARSET_UTF8));
        }
        return mac.doFinal();
    }

    public static byte[] hmacSha1(Map<String, Object> parameters, String signingKey) {
        Mac mac;
        try {
            mac = Mac.getInstance(HMAC_SHA1);
            mac.init(SignatureUtil.buildKey(SignatureUtil.toBytes(signingKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        ArrayList<String> parameterToSort = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            parameterToSort.add(entry.getKey() + entry.getValue());
        }
        Collections.sort(parameterToSort);
        for (String paramToSign : parameterToSort) {
            mac.update(paramToSign.getBytes(CHARSET_UTF8));
        }
        return mac.doFinal();
    }

    private static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(CHARSET_NAME_UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String hmacSha1ToHexStr(byte[] data, byte[] key, int offset, int len) {
        byte[] rawHmac = SignatureUtil.hmacSha1(data, key, offset, len);
        return SignatureUtil.encodeHexStr(rawHmac);
    }

    public static byte[] hmacSha1(byte[] data, byte[] key, int offset, int len) {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1);
            mac.init(signingKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        mac.update(data, offset, len);
        return mac.doFinal();
    }

    public static String hmacSha1ToBase64(byte[] data, String securityKey) {
        if (null == data || null == securityKey) {
            return null;
        }
        byte[] securityKeyBytes = securityKey.getBytes(CHARSET_UTF8);
        byte[] hmacSha1 = SignatureUtil.hmacSha1(data, securityKeyBytes, 0, data.length);
        return SignatureUtil.newStringUtf8(Base64.encodeBase64(hmacSha1, false), CHARSET_UTF8);
    }

    public static String newStringUtf8(byte[] bytes, Charset charset) {
        return bytes == null ? null : new String(bytes, charset);
    }
}

