/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.request;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.request.TopostoreRequest;
import com.aliyun.openservices.log.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListTopostoreRelationRequest
extends TopostoreRequest {
    private String topostoreName;
    private List<String> relationIds = new ArrayList<String>();
    private List<String> relationTypes = new ArrayList<String>();
    private List<String> srcNodeIds = new ArrayList<String>();
    private List<String> dstNodeIds = new ArrayList<String>();
    private String propertyKey = "";
    private String propertyValue = "";
    private Integer offset = 0;
    private Integer size = 200;
    private Map<String, String> properties = new HashMap<String, String>();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        this.properties = properties;
    }

    public ListTopostoreRelationRequest() {
    }

    public ListTopostoreRelationRequest(String topostoreName) {
        this(topostoreName, new ArrayList<String>(), new ArrayList<String>(), "", "", 0, 200);
    }

    public ListTopostoreRelationRequest(String topostoreName, List<String> relationIds) {
        this(topostoreName, relationIds, new ArrayList<String>(), "", "", 0, 200);
    }

    public ListTopostoreRelationRequest(String topostoreName, List<String> relationIds, List<String> relationTypes, String propertyKey, String propertyValue, Integer offset, Integer size) {
        this.topostoreName = topostoreName;
        if (relationIds != null) {
            this.relationIds = relationIds;
        }
        if (relationTypes != null) {
            this.relationTypes = relationTypes;
        }
        this.propertyKey = propertyKey;
        this.propertyValue = propertyValue;
        this.offset = offset;
        this.size = size;
    }

    public ListTopostoreRelationRequest(String topostoreName, String propertyKey, String propertyValue) {
        this(topostoreName, new ArrayList<String>(), new ArrayList<String>(), propertyKey, propertyValue, 0, 200);
    }

    public String getTopostoreName() {
        return this.topostoreName;
    }

    public void setTopostoreName(String topostoreName) {
        this.topostoreName = topostoreName;
    }

    public List<String> getRelationIds() {
        return this.relationIds;
    }

    public void setRelationIds(List<String> relationIds) {
        if (relationIds == null) {
            return;
        }
        this.relationIds = relationIds;
    }

    public ListTopostoreRelationRequest addProperties(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public void setRelationIds(String ... relationIds) {
        this.relationIds = Arrays.asList(relationIds);
    }

    public ListTopostoreRelationRequest addRelationId(String relationId) {
        this.relationIds.add(relationId);
        return this;
    }

    public void setRelationTypes(String ... relationTypes) {
        this.relationTypes = Arrays.asList(relationTypes);
    }

    public ListTopostoreRelationRequest addRelationType(String relationType) {
        this.relationTypes.add(relationType);
        return this;
    }

    public void setSrcNodeIds(String ... srcNodeIds) {
        this.srcNodeIds = Arrays.asList(srcNodeIds);
    }

    public ListTopostoreRelationRequest addSrcNodeId(String srcNodeId) {
        this.srcNodeIds.add(srcNodeId);
        return this;
    }

    public void setDstNodeIds(String ... dstNodeIds) {
        this.dstNodeIds = Arrays.asList(dstNodeIds);
    }

    public ListTopostoreRelationRequest addDstNodeId(String dstNodeId) {
        this.dstNodeIds.add(dstNodeId);
        return this;
    }

    public List<String> getRelationTypes() {
        return this.relationTypes;
    }

    public void setRelationTypes(List<String> relationTypes) {
        if (relationTypes == null) {
            return;
        }
        this.relationTypes = relationTypes;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public List<String> getSrcNodeIds() {
        return this.srcNodeIds;
    }

    public void setSrcNodeIds(List<String> srcNodeIds) {
        if (srcNodeIds == null) {
            return;
        }
        this.srcNodeIds = srcNodeIds;
    }

    public List<String> getDstNodeIds() {
        return this.dstNodeIds;
    }

    public void setDstNodeIds(List<String> dstNodeIds) {
        if (dstNodeIds == null) {
            return;
        }
        this.dstNodeIds = dstNodeIds;
    }

    @Override
    public Map<String, String> GetAllParams() {
        if (this.offset != null) {
            this.SetParam("offset", this.offset.toString());
        }
        if (this.size != null) {
            this.SetParam("size", this.size.toString());
        }
        if (this.relationIds != null && !this.relationIds.isEmpty()) {
            this.SetParam("relationIds", Utils.join(",", Utils.removeNullItems(this.relationIds)));
        }
        if (this.relationTypes != null && !this.relationTypes.isEmpty()) {
            this.SetParam("relationTypes", Utils.join(",", Utils.removeNullItems(this.relationTypes)));
        }
        if (this.srcNodeIds != null && !this.srcNodeIds.isEmpty()) {
            this.SetParam("srcNodeIds", Utils.join(",", Utils.removeNullItems(this.srcNodeIds)));
        }
        if (this.dstNodeIds != null && !this.dstNodeIds.isEmpty()) {
            this.SetParam("dstNodeIds", Utils.join(",", Utils.removeNullItems(this.dstNodeIds)));
        }
        if (this.propertyKey != null && this.propertyKey.length() > 0) {
            this.SetParam("propertyKey", this.propertyKey);
        }
        if (this.propertyValue != null && this.propertyValue.length() > 0) {
            this.SetParam("propertyValue", this.propertyValue);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            JSONObject proObj = new JSONObject();
            for (Map.Entry<String, String> kv : this.properties.entrySet()) {
                proObj.put(kv.getKey(), (Object)kv.getValue());
            }
            try {
                this.SetParam("properties", URLEncoder.encode(new String(Base64.getEncoder().encodeToString(proObj.toJSONString().getBytes())), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return super.GetAllParams();
    }
}

