/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2.entity;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public class StreamData {
    int streamId;
    Http2Headers headers;
    List<byte[]> data = new ArrayList<byte[]>();
    int dataSize;
    boolean endStream;

    public StreamData(int streamId) {
        this.headers = new DefaultHttp2Headers();
        this.streamId = streamId;
    }

    public void addData(byte[] bytes) {
        this.data.add(bytes);
        this.dataSize += bytes.length;
    }

    public byte[] readAllData() {
        if (this.dataSize == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(this.dataSize);
        for (byte[] bytes : this.data) {
            outputStream.write(bytes, 0, bytes.length);
        }
        return outputStream.toByteArray();
    }

    public void addHeaders(Http2Headers headers) {
        this.headers.add((Headers)headers);
    }

    public void clearData() {
        this.data.clear();
    }

    public String toString() {
        return "headers: " + this.headers + ", content: " + new String(this.readAllData());
    }

    public int getStreamId() {
        return this.streamId;
    }

    public Http2Headers getHeaders() {
        return this.headers;
    }

    public List<byte[]> getData() {
        return this.data;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setHeaders(Http2Headers headers) {
        this.headers = headers;
    }

    public void setData(List<byte[]> data) {
        this.data = data;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public void setEndStream(boolean endStream) {
        this.endStream = endStream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamData)) {
            return false;
        }
        StreamData other = (StreamData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        Http2Headers this$headers = this.getHeaders();
        Http2Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        List<byte[]> this$data = this.getData();
        List<byte[]> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        if (this.getDataSize() != other.getDataSize()) {
            return false;
        }
        return this.isEndStream() == other.isEndStream();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStreamId();
        Http2Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        List<byte[]> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        result = result * 59 + this.getDataSize();
        result = result * 59 + (this.isEndStream() ? 79 : 97);
        return result;
    }
}

