/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.stream;

import com.aliyun.openservices.iot.api.http2.callback.AbstractHttp2StreamDataReceiver;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.connection.StreamWriteContext;
import com.aliyun.openservices.iot.api.http2.entity.BaseHttpEntity;
import com.aliyun.openservices.iot.api.http2.entity.Http2Response;
import com.aliyun.openservices.iot.api.http2.entity.StreamData;
import com.aliyun.openservices.iot.api.util.StreamUtil;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamServiceContext {
    private static final Logger log = LoggerFactory.getLogger(StreamServiceContext.class);
    private static final String RESPONSE_STATUS = "x-response-status";
    private static final String CONTENT_LENGTH = "content-length";
    private Connection connection;
    private String requestId;
    private String requestPath;
    private String dataStreamId;
    private String serviceName;

    public StreamServiceContext(Connection connection, String serviceName) {
        this.connection = connection;
        this.serviceName = serviceName;
    }

    public StreamServiceContext(Connection connection, BaseHttpEntity request, String serviceName) {
        this(connection, serviceName);
        this.updateContext(request);
    }

    public CompletableFuture<StreamWriteContext> writeHeader(Http2Headers headers, boolean endOfStream) {
        if (!headers.contains((Object)CONTENT_LENGTH)) {
            headers.set((Object)CONTENT_LENGTH, (Object)String.valueOf(Integer.MAX_VALUE));
        }
        headers.add((Object)"x-request-id", (Object)this.requestId);
        headers.add((Object)RESPONSE_STATUS, (Object)headers.status());
        headers.add((Object)"x-data-stream-id", (Object)this.dataStreamId);
        headers.path((CharSequence)this.requestPath);
        headers.method((CharSequence)"POST");
        headers.scheme((CharSequence)"https");
        headers.remove((Object)Http2Headers.PseudoHeaderName.STATUS.value());
        return this.connection.writeHeaders(headers, endOfStream, null);
    }

    public void writeResponse(Http2Response response) {
        Http2Headers headers = response.getHeaders();
        headers.add((Object)"x-request-id", (Object)this.requestId);
        headers.add((Object)RESPONSE_STATUS, (Object)headers.status());
        headers.add((Object)"x-data-stream-id", (Object)this.dataStreamId);
        headers.path((CharSequence)this.requestPath);
        headers.method((CharSequence)"POST");
        headers.scheme((CharSequence)"https");
        headers.remove((Object)Http2Headers.PseudoHeaderName.STATUS.value());
        byte[] data = response.getContent();
        boolean endOfStream = data == null || data.length == 0;
        CompletableFuture<StreamWriteContext> future = this.connection.writeHeaders(headers, endOfStream, null);
        if (!endOfStream) {
            future.thenAccept(writeOperation -> writeOperation.writeData(response.getContent(), true));
        }
        future.thenAccept(StreamWriteContext::closeStream);
    }

    public CompletableFuture<Http2Response> closeStream() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.add((Object)"x-data-stream-id", (Object)this.dataStreamId);
        headers.path((CharSequence)("/stream/receiver_close" + this.serviceName));
        headers.method((CharSequence)"POST");
        headers.scheme((CharSequence)"https");
        headers.remove((Object)Http2Headers.PseudoHeaderName.STATUS.value());
        final CompletableFuture<Http2Response> future = new CompletableFuture<Http2Response>();
        headers.set((Object)"context-length", (Object)"0");
        this.connection.writeHeaders((Http2Headers)headers, true, new AbstractHttp2StreamDataReceiver(){

            @Override
            public void onStreamDataReceived(Connection connection, Http2Stream stream, StreamData streamData) {
                log.debug("close stream result: {}", (Object)new String(streamData.readAllData()));
                StreamUtil.removeDataStreamContext(connection, StreamServiceContext.this.dataStreamId);
                future.complete(new Http2Response(streamData.getHeaders(), streamData.readAllData()));
            }

            @Override
            public void onStreamError(Connection connection, Http2Stream stream, IOException e) {
                log.error("close stream occurs error {}, {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void updateContext(BaseHttpEntity httpEntity) {
        this.requestId = httpEntity.getRequestId();
        this.requestPath = httpEntity.getHeaders().path().toString();
        this.dataStreamId = StreamUtil.getDataStreamId(httpEntity.getHeaders());
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getDataStreamId() {
        return this.dataStreamId;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

